/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.file;

import de.christofreichardt.diagnosis.AbstractTracer;
import de.christofreichardt.diagnosis.LogLevel;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import de.christofreichardt.diagnosis.io.TracePrintStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.w3c.dom.Node;

public class FileTracer
extends AbstractTracer {
    protected File traceLogfile;
    protected FileOutputStream fileOutputStream;
    protected volatile long byteLimit = -1L;
    protected Path logDirPath = FileSystems.getDefault().getPath("log", new String[0]);
    protected int counter = -1;
    protected TracePrintStream.LockAccess lockAccess;

    public FileTracer(String name) {
        super(name);
    }

    public Path getLogDirPath() {
        return this.logDirPath;
    }

    public void setLogDirPath(Path logDirPath) {
        if (!logDirPath.toFile().isDirectory()) {
            throw new IllegalArgumentException("Need a path to a directory.");
        }
        this.logDirPath = logDirPath;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public void setByteLimit(long byteLimit) {
        this.byteLimit = byteLimit;
    }

    @Override
    public void open() {
        try {
            if (!this.isOpened()) {
                Path logFilePath = this.logDirPath.resolve(String.format("%s.log", super.getName()));
                System.out.printf("%s Opening [%s] ...%n", this.formatVersionInfo(), logFilePath.toAbsolutePath());
                this.traceLogfile = logFilePath.toFile();
                this.fileOutputStream = new FileOutputStream(this.traceLogfile);
                this.setBufferedOutputStream(new BufferedOutputStream(this.fileOutputStream, this.getBufferSize()));
                this.setTracePrintStream(new TracePrintStream(this.getBufferedOutputStream(), this.getThreadMap()));
                this.getTracePrintStream().printf("--> TraceLog opened!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %s%n", ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                this.getTracePrintStream().printf("    Bufsize  : %d%n", this.getBufferSize());
                this.getTracePrintStream().printf("    Autoflush: %b%n%n", this.isAutoflush());
                this.setOpened(true);
            } else {
                System.err.println("WARNING: Tracelog is opened already.");
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void close() {
        try {
            if (this.isOpened()) {
                this.getTracePrintStream().println();
                this.getTracePrintStream().printf("--> TraceLog closing!%n", new Object[0]);
                this.getTracePrintStream().printf("    Time     : %s%n", ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
                System.out.printf("%s Closing [%s] ...%n", this.formatStreamErrorState(), this.traceLogfile.toPath().toAbsolutePath());
                this.getTracePrintStream().close();
                this.getBufferedOutputStream().close();
                this.fileOutputStream.close();
                this.setOpened(false);
            } else {
                System.err.println("WARNING: Tracelog is closed already.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    protected void readConfiguration(XPath xpath, Node node) throws XPathExpressionException, AbstractTracer.Exception {
        super.readConfiguration(xpath, node);
        File logDir = new File((String)xpath.evaluate("./dns:LogDir/text()", node, XPathConstants.STRING));
        if (!logDir.isDirectory()) {
            throw new AbstractTracer.Exception("Invalid path to directory configured for tracer: " + super.getName());
        }
        this.logDirPath = logDir.toPath();
        String strLimit = (String)xpath.evaluate("./dns:Limit/text()", node, XPathConstants.STRING);
        this.byteLimit = !strLimit.isEmpty() ? Long.parseLong(strLimit) : -1L;
        System.out.println("this.logDir = " + this.logDirPath);
        System.out.println("this.byteLimit = " + this.byteLimit);
    }

    public void requestLockAccess(TracePrintStream.LockAccess lockAccess) {
        this.lockAccess = lockAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkLimit() {
        block5: {
            this.getTracePrintStream().lock();
            this.getTracePrintStream().grantLockAccess(this);
            ReentrantLock reentrantLock = this.lockAccess.getLock();
            try {
                if (this.byteLimit == -1L || this.traceLogfile == null || this.traceLogfile.length() <= this.byteLimit) break block5;
                this.close();
                int pos = this.traceLogfile.getName().lastIndexOf(46);
                String splitFilename = String.format("%s.%d.log", this.traceLogfile.getName().substring(0, pos), ++this.counter);
                try {
                    Files.move(this.traceLogfile.toPath(), this.logDirPath.resolve(splitFilename), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                this.open();
            }
            finally {
                this.getTracePrintStream().grantLockAccess(this);
                this.lockAccess.setLock(reentrantLock);
                this.getTracePrintStream().unlock();
            }
        }
    }

    @Override
    public IndentablePrintStream out() {
        this.checkLimit();
        return super.out();
    }

    @Override
    public void logException(LogLevel logLevel, Throwable throwable, Class<?> clazz, String methodName) {
        super.logException(logLevel, throwable, clazz, methodName);
        this.checkLimit();
    }

    @Override
    public void logMessage(LogLevel logLevel, String message, Class<?> clazz, String methodName) {
        super.logMessage(logLevel, message, clazz, methodName);
        this.checkLimit();
    }
}

