/*
 * Decompiled with CFR 0.152.
 */
package de.christofreichardt.diagnosis.io;

import de.christofreichardt.diagnosis.AbstractThreadMap;
import de.christofreichardt.diagnosis.file.FileTracer;
import de.christofreichardt.diagnosis.io.IndentablePrintStream;
import de.christofreichardt.diagnosis.io.NullOutputStream;
import java.io.BufferedOutputStream;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;

public class TracePrintStream
extends IndentablePrintStream {
    public static final int MAX_INDENT_NUMBER = 100;
    public static final int INDENT_CHAR_NUMBER = 2;
    protected static final String[] INDENT_STRING = new String[100];
    protected ReentrantLock lock = new ReentrantLock();
    protected final AbstractThreadMap threadMap;

    public void grantLockAccess(FileTracer fileTracer) {
        fileTracer.requestLockAccess(new LockAccess());
    }

    public TracePrintStream(AbstractThreadMap threadMap) {
        super(new NullOutputStream());
        this.threadMap = threadMap;
    }

    public TracePrintStream(BufferedOutputStream out, AbstractThreadMap threadMap) {
        super(out);
        this.threadMap = threadMap;
    }

    @Override
    public IndentablePrintStream printIndent(String s) {
        this.printIndentString();
        this.print(s);
        return this;
    }

    @Override
    public IndentablePrintStream printIndentln(String s) {
        this.printIndentString();
        this.println(s);
        return this;
    }

    @Override
    public IndentablePrintStream printIndentString() {
        int level = this.threadMap.getCurrentStackSize();
        if (level < 0) {
            System.err.println("ERROR: Trace stream unlocked but no stack!");
        } else if (level >= 0 && level < 100) {
            this.print(INDENT_STRING[level]);
        } else {
            this.print(INDENT_STRING[99]);
        }
        return this;
    }

    @Override
    public IndentablePrintStream printfIndentln(String format, Object ... args) {
        this.printIndentString();
        this.printf(format, args);
        this.println();
        return this;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void runWithLock(Runnable runnable) {
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    static {
        for (int i = 0; i < 100; ++i) {
            char[] spaces = new char[i * 2];
            Arrays.fill(spaces, ' ');
            TracePrintStream.INDENT_STRING[i] = new String(spaces);
        }
    }

    public class LockAccess {
        private LockAccess() {
        }

        public ReentrantLock getLock() {
            return TracePrintStream.this.lock;
        }

        public void setLock(ReentrantLock lock) {
            TracePrintStream.this.lock = lock;
        }
    }
}

