/*
 * Decompiled with CFR 0.152.
 */
package de.clashsoft.gentreesrc.antlr;

import de.clashsoft.gentreesrc.antlr.GenTreeSrcBaseListener;
import de.clashsoft.gentreesrc.antlr.GenTreeSrcLexer;
import de.clashsoft.gentreesrc.antlr.GenTreeSrcParser;
import de.clashsoft.gentreesrc.tree.DefinitionFile;
import de.clashsoft.gentreesrc.tree.Node;
import de.clashsoft.gentreesrc.tree.decl.Attributes;
import de.clashsoft.gentreesrc.tree.decl.Modifier;
import de.clashsoft.gentreesrc.tree.decl.PropertyDecl;
import de.clashsoft.gentreesrc.tree.decl.TypeDecl;
import de.clashsoft.gentreesrc.tree.type.ArrayType;
import de.clashsoft.gentreesrc.tree.type.ListType;
import de.clashsoft.gentreesrc.tree.type.MapType;
import de.clashsoft.gentreesrc.tree.type.NamedType;
import de.clashsoft.gentreesrc.tree.type.OptionalType;
import de.clashsoft.gentreesrc.tree.type.Type;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class ASTListener
extends GenTreeSrcBaseListener {
    private DefinitionFile definitionFile;
    private TypeDecl currentDeclaration;
    private Deque<Node> stack = new ArrayDeque<Node>(2);

    public ASTListener(DefinitionFile definitionFile) {
        this.definitionFile = definitionFile;
    }

    public static DefinitionFile parse(String descriptionFile) throws IOException {
        GenTreeSrcLexer lexer = new GenTreeSrcLexer(CharStreams.fromFileName((String)descriptionFile));
        GenTreeSrcParser parser = new GenTreeSrcParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        DefinitionFile definitionFile = DefinitionFile.of(new ArrayList<TypeDecl>());
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new ASTListener(definitionFile), (ParseTree)parser.main());
        return definitionFile;
    }

    private <T extends Node> void push(T value) {
        this.stack.push(value);
    }

    private <T> T pop() {
        return (T)this.stack.pop();
    }

    private <T> List<T> pop(Class<T> type, int count) {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(count, null));
        for (int i = count - 1; i >= 0; --i) {
            result.set(i, type.cast(this.stack.pop()));
        }
        return result;
    }

    @Override
    public void enterTypeDeclaration(GenTreeSrcParser.TypeDeclarationContext ctx) {
        Attributes attributes = new Attributes();
        for (GenTreeSrcParser.TypeModifierContext modCtx : ctx.typeModifier()) {
            if (modCtx.ABSTRACT() != null) {
                attributes.add(Modifier.ABSTRACT);
                continue;
            }
            if (modCtx.IMPORT() == null) continue;
            attributes.add(Modifier.IMPORT);
        }
        String packageName = ASTListener.getPackageName(ctx.packageName());
        String className = ctx.className.getText();
        TypeDecl parent = this.currentDeclaration;
        String fullPackageName = ASTListener.getPackageName(parent, packageName);
        this.currentDeclaration = TypeDecl.of(attributes, fullPackageName, className, parent, new ArrayList<PropertyDecl>(), new ArrayList<TypeDecl>());
        if (parent != null) {
            parent.getSubTypes().add(this.currentDeclaration);
        } else {
            this.definitionFile.getDeclarations().add(this.currentDeclaration);
        }
    }

    private static String getPackageName(GenTreeSrcParser.PackageNameContext ctx) {
        String packageText = ctx.getText();
        return packageText.isEmpty() ? packageText : packageText.substring(0, packageText.length() - 1);
    }

    private static String getPackageName(TypeDecl parent, String child) {
        if (parent == null) {
            return child;
        }
        if (child.isEmpty()) {
            return parent.getPackageName();
        }
        return parent.getPackageName() + '.' + child;
    }

    @Override
    public void exitProperty(GenTreeSrcParser.PropertyContext ctx) {
        Attributes attributes = new Attributes();
        for (GenTreeSrcParser.PropertyModifierContext modCtx : ctx.propertyModifier()) {
            if (modCtx.DELEGATE() != null) {
                attributes.add(Modifier.DELEGATE);
                continue;
            }
            if (modCtx.READONLY() != null) {
                attributes.add(Modifier.READONLY);
                continue;
            }
            if (modCtx.NOCONSTRUCT() == null) continue;
            attributes.add(Modifier.NOCONSTRUCT);
        }
        String name = ctx.name.getText();
        PropertyDecl property = PropertyDecl.of(this.currentDeclaration, attributes, name, (Type)this.pop());
        this.currentDeclaration.getProperties().add(property);
    }

    @Override
    public void exitNamedType(GenTreeSrcParser.NamedTypeContext ctx) {
        String name = ctx.name.getText();
        GenTreeSrcParser.GenericArgumentsContext genericArguments = ctx.genericArguments();
        List<Type> args = genericArguments != null ? this.pop(Type.class, genericArguments.type().size()) : null;
        this.push(NamedType.of(name, args));
    }

    @Override
    public void exitListType(GenTreeSrcParser.ListTypeContext ctx) {
        this.push(ListType.of((Type)this.pop()));
    }

    @Override
    public void exitMapType(GenTreeSrcParser.MapTypeContext ctx) {
        Type valueType = (Type)this.pop();
        Type keyType = (Type)this.pop();
        this.push(MapType.of(keyType, valueType));
    }

    @Override
    public void exitArrayTypeSuffix(GenTreeSrcParser.ArrayTypeSuffixContext ctx) {
        this.push(ArrayType.of((Type)this.pop()));
    }

    @Override
    public void exitOptionalTypeSuffix(GenTreeSrcParser.OptionalTypeSuffixContext ctx) {
        this.push(OptionalType.of((Type)this.pop()));
    }

    @Override
    public void exitTypeDeclaration(GenTreeSrcParser.TypeDeclarationContext ctx) {
        this.currentDeclaration = this.currentDeclaration.getSuperType();
    }
}

