/*
 * Decompiled with CFR 0.152.
 */
package de.clemenskeppler.materialsearchview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Build;
import android.support.annotation.Dimension;
import android.support.annotation.Keep;
import android.support.v4.view.MenuItemCompat;
import android.support.v7.appcompat.R;
import android.support.v7.widget.CardView;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.SearchView;
import android.support.v7.widget.Toolbar;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import de.clemenskeppler.materialsearchview.R;

public class MaterialSearchView
extends FrameLayout {
    private Animation addOverlayAnim = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.fade_in);
    private View overlay;
    private FrameLayout overlayContainer;
    private MenuItem menuItemSearch;
    private int animationDuration;
    private Toolbar toolbar;
    private CardView searchResultsContainer;
    private int positionFromRight;
    private boolean hasOverflow;
    private int positionOffset;
    private int overflowOffset;
    private Animation slideDown;
    private boolean cancelOnTouchOutside;
    private SearchView searchView;
    private RecyclerView searchResults;
    private Path revealPath;
    private boolean hideOnKeyboardClose;
    private float clipRadius;
    private boolean clipOutlines;
    @Dimension
    private int searchbarHeight;
    @Dimension
    private int defaultActionBarHeight;
    private Point displaySize;
    private boolean animating;
    private Animator.AnimatorListener circleAnimShowListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            MaterialSearchView.this.animating = true;
            super.onAnimationStart(animation);
        }

        public void onAnimationEnd(Animator animation) {
            super.onAnimationStart(animation);
            MaterialSearchView.this.searchResultsContainer.setVisibility(0);
            MaterialSearchView.this.searchResultsContainer.startAnimation(MaterialSearchView.this.slideDown);
            MaterialSearchView.this.showOverlay();
            MaterialSearchView.this.animating = false;
        }
    };
    private Animator.AnimatorListener circleAnimHideListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            MaterialSearchView.this.animating = true;
            super.onAnimationStart(animation);
            MaterialSearchView.this.searchResultsContainer.setVisibility(8);
            MaterialSearchView.this.removeOverlay();
        }

        public void onAnimationEnd(Animator animation) {
            MaterialSearchView.this.animating = false;
            super.onAnimationEnd(animation);
            MaterialSearchView.this.setVisibility(8);
            MaterialSearchView.this.clipOutlines = false;
        }
    };
    private int cy;
    private int cx;
    private int width;

    public MaterialSearchView(Context context) {
        super(context);
        this.positionFromRight = 1;
        MaterialSearchView.inflate((Context)context, (int)R.layout.search_toolbar, (ViewGroup)this);
    }

    public MaterialSearchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
        MaterialSearchView.inflate((Context)context, (int)R.layout.search_toolbar, (ViewGroup)this);
    }

    public MaterialSearchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
        MaterialSearchView.inflate((Context)context, (int)R.layout.search_toolbar, (ViewGroup)this);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.setUpViews();
        this.setUpSearchToolbar();
        this.width = this.toolbar.getWidth();
        if (this.width <= 0) {
            this.width += this.displaySize.x - this.getPaddingLeft() - this.getPaddingRight();
        }
    }

    public void hide() {
        this.circularHide();
        this.menuItemSearch.collapseActionView();
    }

    public void show() {
        ViewGroup parent = (ViewGroup)this.getParent();
        parent.removeView((View)this);
        this.overlayContainer.addView((View)this);
        parent.addView((View)this.overlayContainer);
        this.overlay.setVisibility(8);
        this.circularReveal();
        this.menuItemSearch.expandActionView();
    }

    private void showOverlay() {
        this.overlay.setVisibility(0);
        this.overlay.startAnimation(this.addOverlayAnim);
    }

    private void removeOverlay() {
        this.overlayContainer.removeView((View)this);
        ViewGroup parent = (ViewGroup)this.overlayContainer.getParent();
        if (parent != null) {
            parent.removeView((View)this.overlayContainer);
            parent.addView((View)this);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.cancelOnTouchOutside) {
            this.overlay.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!v.equals((Object)MaterialSearchView.this) && MaterialSearchView.this.getVisibility() == 0 && !MaterialSearchView.this.animating) {
                        MaterialSearchView.this.slideDown.cancel();
                        MaterialSearchView.this.addOverlayAnim.cancel();
                        MaterialSearchView.this.hide();
                    }
                }
            });
        }
    }

    public SearchView getSearchView() {
        return this.searchView;
    }

    public RecyclerView getSearchResults() {
        return this.searchResults;
    }

    @Keep
    private void setClipRadius(float clipRadius) {
        this.clipRadius = clipRadius;
        this.invalidate();
    }

    private void circularReveal() {
        Animator anim2;
        if (Build.VERSION.SDK_INT >= 21) {
            anim2 = ViewAnimationUtils.createCircularReveal((View)this, (int)this.cx, (int)this.cy, (float)0.0f, (float)this.width);
        } else {
            this.clipOutlines = true;
            anim2 = ObjectAnimator.ofFloat((Object)((Object)this), (String)"ClipRadius", (float[])new float[]{0.0f, this.width});
        }
        anim2.addListener(this.circleAnimShowListener);
        anim2.setDuration((long)this.animationDuration);
        this.setVisibility(0);
        anim2.start();
    }

    private void circularHide() {
        Animator animator;
        if (Build.VERSION.SDK_INT >= 21) {
            animator = ViewAnimationUtils.createCircularReveal((View)this, (int)this.cx, (int)this.cy, (float)this.width, (float)0.0f);
        } else {
            this.clipOutlines = true;
            animator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"ClipRadius", (float[])new float[]{this.width, 0.0f});
        }
        animator.addListener(this.circleAnimHideListener);
        animator.setDuration((long)this.animationDuration);
        animator.start();
    }

    public void draw(Canvas canvas) {
        if (!this.clipOutlines) {
            super.draw(canvas);
            return;
        }
        int state = canvas.save();
        this.revealPath.reset();
        this.revealPath.addCircle((float)this.cx, (float)this.cy, this.clipRadius, Path.Direction.CW);
        canvas.clipPath(this.revealPath);
        super.draw(canvas);
        canvas.restoreToCount(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(Context context, AttributeSet attrs) {
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaterialSearchView, 0, 0);
        try {
            this.positionFromRight = a.getInt(R.styleable.MaterialSearchView_searchIconPositionFromRight, 0);
            this.hasOverflow = a.getBoolean(R.styleable.MaterialSearchView_hasOverflow, false);
            this.searchbarHeight = a.getDimensionPixelSize(R.styleable.MaterialSearchView_searchBarHeight, -1);
            this.cancelOnTouchOutside = a.getBoolean(R.styleable.MaterialSearchView_cancelOnTouchOutside, true);
            this.animationDuration = a.getInteger(R.styleable.MaterialSearchView_circularAnimationTime, 250);
            this.hideOnKeyboardClose = a.getBoolean(R.styleable.MaterialSearchView_hideOnKeyboardClose, true);
        }
        finally {
            a.recycle();
        }
        Display display = ((WindowManager)this.getContext().getSystemService("window")).getDefaultDisplay();
        this.displaySize = new Point();
        display.getSize(this.displaySize);
        this.setUpVariables();
    }

    private void setUpVariables() {
        Resources resources = this.getResources();
        if (this.positionFromRight > 0) {
            this.positionOffset = this.positionFromRight * resources.getDimensionPixelSize(R.dimen.abc_action_button_min_width_material) + resources.getDimensionPixelSize(R.dimen.abc_button_padding_horizontal_material) / 2;
        }
        this.positionOffset += this.getResources().getDimensionPixelSize(R.dimen.abc_action_button_min_width_material) / 2;
        if (this.hasOverflow) {
            this.overflowOffset = resources.getDimensionPixelSize(R.dimen.abc_action_button_min_width_overflow_material);
        }
        TypedValue tv = new TypedValue();
        if (this.getContext().getTheme().resolveAttribute(16843499, tv, true)) {
            this.defaultActionBarHeight = TypedValue.complexToDimensionPixelSize((int)tv.data, (DisplayMetrics)resources.getDisplayMetrics());
        }
        this.cx = this.displaySize.x - this.positionOffset - this.overflowOffset;
        this.cy = this.defaultActionBarHeight / 2;
        this.slideDown = this.createSlideDownAnimation();
        this.revealPath = new Path();
        this.clipOutlines = false;
    }

    private Animation createSlideDownAnimation() {
        Animation result = AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.slide_down);
        result.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        return result;
    }

    private void setUpViews() {
        this.toolbar = (Toolbar)this.findViewById(R.id.search_toolbar);
        this.searchResults = (RecyclerView)this.findViewById(R.id.search_results);
        if (this.searchbarHeight != -1) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.toolbar.getLayoutParams();
            layoutParams.height = this.searchbarHeight;
            this.toolbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.searchResultsContainer = (CardView)this.findViewById(R.id.search_results_container);
        this.overlayContainer = (FrameLayout)MaterialSearchView.inflate((Context)this.getContext(), (int)R.layout.overlay, null);
        this.overlay = this.overlayContainer.findViewById(R.id.overlay);
    }

    private void setUpSearchToolbar() {
        this.toolbar.inflateMenu(R.menu.menu_search);
        Menu searchMenu = this.toolbar.getMenu();
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MaterialSearchView.this.circularHide();
            }
        });
        this.menuItemSearch = searchMenu.findItem(R.id.action_filter_search);
        this.searchView = (SearchView)this.menuItemSearch.getActionView();
        MenuItemCompat.setOnActionExpandListener((MenuItem)this.menuItemSearch, (MenuItemCompat.OnActionExpandListener)new MenuItemCompat.OnActionExpandListener(){

            public boolean onMenuItemActionCollapse(MenuItem item) {
                MaterialSearchView.this.circularHide();
                return true;
            }

            public boolean onMenuItemActionExpand(MenuItem item) {
                return true;
            }
        });
        if (this.hideOnKeyboardClose) {
            TextView searchText = (TextView)this.searchView.findViewById(R.id.search_src_text);
            searchText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                public void onFocusChange(View v, boolean hasFocus) {
                    if (!hasFocus && MaterialSearchView.this.getVisibility() == 0 && !MaterialSearchView.this.animating) {
                        MaterialSearchView.this.hide();
                    }
                }
            });
        }
    }
}

