package de.codecamp.vaadin.security.spring.access.route;

import javax.servlet.http.HttpServletResponse;

import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasErrorParameter;


public class DefaultRouteAccessDeniedError
  extends
    Composite<VerticalLayout>
  implements
    HasErrorParameter<RouteAccessDeniedException>
{

  @Override
  public int setErrorParameter(BeforeEnterEvent event,
      ErrorParameter<RouteAccessDeniedException> parameter)
  {
    getContent().add("You don't have the required permissions to access this view.");
    return HttpServletResponse.SC_FORBIDDEN;
  }

}
