package de.codecamp.vaadin.security.spring.authentication;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;


/**
 * {@link AuthenticationSuccessHandler} that provides an appropriate {@link AuthenticationResult}.
 */
public class VaadinAuthenticationSuccessHandler
  extends
    AbstractAuthenticationSuccessFailureHandler
  implements
    AuthenticationSuccessHandler
{

  @Override
  public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response,
      Authentication authentication)
    throws IOException, ServletException
  {
    getSession(request).ifPresent(session ->
    {
      AuthenticationResult result = AuthenticationResult.success();
      session.accessSynchronously(() ->
      {
        session.setAttribute(AuthenticationResult.class, result);
      });
    });
  }

}
