package de.codecamp.vaadin.security.spring.config;

import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;


/**
 * The base class that can be extended instead of {@link WebSecurityConfigurerAdapter} to set up
 * security for a Vaadin UI. Alternatively use {@link VaadinSecurityConfigurer} in case you need to
 * extend a different {@link WebSecurityConfigurerAdapter}.
 * <p>
 * See {@link VaadinSecurityConfigurer} for what is configured.
 *
 * @see VaadinSecurityConfigurer
 * @deprecated WebSecurityConfigurerAdapter is deprecated in Spring Boot 2.7. Use
 *             VaadinSecurityConfigurer to configure the HttpSecurity for your SecurityFilterChain.
 */
@Deprecated
public abstract class VaadinSecurityConfigurerAdapter
  extends
    WebSecurityConfigurerAdapter
{

  @Override
  protected void configure(HttpSecurity http)
    throws Exception
  {
    new VaadinSecurityConfigurer().configure(http);
  }

}
