/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access;

import de.codecamp.vaadin.security.spring.access.AccessEvaluator;
import de.codecamp.vaadin.security.spring.access.AccessRuleException;
import de.codecamp.vaadin.security.spring.access.SecuredAccess;
import java.io.Serializable;
import java.util.Objects;

public class AccessRule
implements Serializable {
    private final String expression;
    private final Class<? extends AccessEvaluator> evaluator;
    private final boolean checkLayout;

    private AccessRule(SecuredAccess securedAccess) {
        this.expression = !securedAccess.value().equals("___NOT_SET___") ? securedAccess.value() : null;
        Class<? extends AccessEvaluator> clazz = this.evaluator = securedAccess.evaluator() != SecuredAccess.NotSetAccessEvaluator.class ? securedAccess.evaluator() : null;
        if (this.expression == null && this.evaluator == null) {
            throw new AccessRuleException("Either a security expression or an AccessEvaluator must be specified.");
        }
        this.checkLayout = securedAccess.checkLayout();
    }

    private AccessRule(String expression, boolean checkLayout) {
        Objects.requireNonNull(expression, "expression must not be null");
        this.expression = expression;
        this.evaluator = null;
        this.checkLayout = checkLayout;
    }

    private AccessRule(Class<? extends AccessEvaluator> evaluator, boolean checkLayout) {
        Objects.requireNonNull(evaluator, "evaluator must not be null");
        this.expression = null;
        this.evaluator = evaluator;
        this.checkLayout = checkLayout;
    }

    public String expression() {
        return this.expression;
    }

    public Class<? extends AccessEvaluator> evaluator() {
        return this.evaluator;
    }

    public boolean checkLayout() {
        return this.checkLayout;
    }

    public static AccessRule asCopyOf(SecuredAccess securedAccess) {
        return new AccessRule(securedAccess);
    }

    public static AccessRule of(String expression) {
        return AccessRule.of(expression, true);
    }

    public static AccessRule of(String expression, boolean checkLayout) {
        return new AccessRule(expression, checkLayout);
    }

    public static AccessRule of(Class<? extends AccessEvaluator> evaluator) {
        return AccessRule.of(evaluator, true);
    }

    public static AccessRule of(Class<? extends AccessEvaluator> evaluator, boolean checkLayout) {
        return new AccessRule(evaluator, checkLayout);
    }
}

