/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.server.VaadinServletRequest;
import de.codecamp.vaadin.security.spring.access.AccessRuleException;
import de.codecamp.vaadin.security.spring.access.VaadinSecurityExpressionHandler;
import de.codecamp.vaadin.security.spring.access.VaadinSecurityExpressionOperations;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessControl;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class VaadinSecurity {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();

    public static VaadinSecurityExpressionOperations check() {
        return VaadinSecurity.check(VaadinSecurity.getRequiredAuthentication());
    }

    public static VaadinSecurityExpressionOperations check(Authentication authentication) {
        Objects.requireNonNull(authentication, "authentication must not be null");
        return VaadinSecurity.getExpressionHandler().createSecurityExpressionRoot(authentication, VaadinServletRequest.getCurrent());
    }

    public static boolean hasAccess(String securityExpression) {
        return VaadinSecurity.hasAccess(VaadinSecurity.getRequiredAuthentication(), securityExpression);
    }

    public static boolean hasAccess(Authentication authentication, String securityExpression) {
        boolean hasAccess;
        Objects.requireNonNull(authentication, "authentication must not be null");
        EvaluationContext evaluationContext = VaadinSecurity.getExpressionHandler().createEvaluationContext(authentication, VaadinServletRequest.getCurrent());
        try {
            hasAccess = (Boolean)SPEL_PARSER.parseExpression(securityExpression).getValue(evaluationContext, Boolean.class);
        }
        catch (IllegalStateException | EvaluationException | ParseException ex) {
            throw new AccessRuleException("Failed to evaluate security expression: " + securityExpression, ex);
        }
        return hasAccess;
    }

    private static VaadinSecurityExpressionHandler getExpressionHandler() {
        return VaadinSecurity.getBean(VaadinSecurityExpressionHandler.class);
    }

    private static Optional<HttpServletRequest> getCurrentHttpRequest() {
        return Optional.ofNullable(RequestContextHolder.getRequestAttributes()).filter(ServletRequestAttributes.class::isInstance).map(ServletRequestAttributes.class::cast).map(ServletRequestAttributes::getRequest);
    }

    private static <BEAN> BEAN getBean(Class<BEAN> beanType) {
        UI ui = UI.getCurrent();
        if (ui != null) {
            return (BEAN)Instantiator.get((UI)ui).getOrCreate(beanType);
        }
        WebApplicationContext applicationContext = VaadinSecurity.getApplicationContext().orElse(null);
        if (applicationContext != null) {
            return (BEAN)applicationContext.getBean(beanType);
        }
        throw new IllegalStateException("No current UI or HTTP request available.");
    }

    private static Optional<WebApplicationContext> getApplicationContext() {
        return VaadinSecurity.getCurrentHttpRequest().map(request -> WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext()));
    }

    public static boolean hasAccessTo(Class<? extends Component> navigationTarget) {
        return VaadinSecurity.getBean(RouteAccessControl.class).hasAccessTo(navigationTarget);
    }

    public static boolean hasAccessTo(String routePath) {
        return VaadinSecurity.getBean(RouteAccessControl.class).hasAccessTo(routePath);
    }

    private static Authentication getRequiredAuthentication() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("No Authentication found. Authentication is available in all request threads and wherever VaadinSession#getCurrent() is available.");
        }
        return authentication;
    }

    @Deprecated
    public static Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }
}

