/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.endpoint;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import de.codecamp.vaadin.security.spring.access.AccessEvaluator;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.SecuredAccess;
import de.codecamp.vaadin.security.spring.access.VaadinSecurity;
import de.codecamp.vaadin.security.spring.access.endpoint.EndpointAccessContext;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class EndpointAccessChecker
extends dev.hilla.auth.EndpointAccessChecker {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointAccessChecker.class);
    private ConcurrentMap<Method, AccessRule> accessRuleCache = new ConcurrentHashMap<Method, AccessRule>();

    public EndpointAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        super(accessAnnotationChecker);
    }

    public String check(Method method, HttpServletRequest request) {
        WebApplicationContext applicationContext;
        AccessEvaluator evaluator;
        String expression;
        LOG.trace("Checking access to endpoint method '{} # {}(...)' in {}.", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), method.getDeclaringClass().getName()});
        AccessRule accessRule = this.accessRuleCache.computeIfAbsent(method, m -> EndpointAccessContext.findAnnotation(method, SecuredAccess.class).map(AccessRule::asCopyOf).orElse(null));
        if (accessRule == null) {
            LOG.debug("Delegating to Vaadin's default access control for endpoint method '{} # {}(...)' in {}.", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), method.getDeclaringClass().getName()});
            return super.check(method, request);
        }
        boolean hasAccess = true;
        if (accessRule.expression() != null && !VaadinSecurity.hasAccess(expression = accessRule.expression())) {
            hasAccess = false;
        }
        if (hasAccess && accessRule.evaluator() != null && !(evaluator = (AccessEvaluator)(applicationContext = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)request.getServletContext())).getBean(accessRule.evaluator())).hasAccess(new EndpointAccessContext(method, request))) {
            hasAccess = false;
        }
        if (hasAccess) {
            LOG.debug("Access granted to endpoint method '{} # {}(...)' in {}.", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), method.getDeclaringClass().getName()});
            return null;
        }
        LOG.debug("Access denied to endpoint method '{} # {}(...)' in {}.", new Object[]{method.getDeclaringClass().getSimpleName(), method.getName(), method.getDeclaringClass().getName()});
        return "Access denied";
    }
}

