/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.flow.server.startup.ApplicationRouteRegistry;
import de.codecamp.vaadin.security.spring.access.route.DefaultRouteAccessDeniedError;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessControl;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedException;
import java.util.Collections;

public class RouteAccessControlServiceInitListener
implements VaadinServiceInitListener,
UIInitListener {
    private static final VaadinAccessControlAdapter ACCESS_CONTROL_ADAPTER = new VaadinAccessControlAdapter();

    public void serviceInit(ServiceInitEvent serviceInitEvent) {
        ApplicationRouteRegistry routeRegistry = ApplicationRouteRegistry.getInstance((VaadinContext)serviceInitEvent.getSource().getContext());
        if (routeRegistry.getConfiguration().getExceptionHandlerByClass(RouteAccessDeniedException.class) == null) {
            routeRegistry.setErrorNavigationTargets(Collections.singleton(DefaultRouteAccessDeniedError.class));
        }
    }

    public void uiInit(UIInitEvent event) {
        event.getUI().addBeforeEnterListener((BeforeEnterListener)ACCESS_CONTROL_ADAPTER);
    }

    @ListenerPriority(value=0x7FFFFFF5)
    private static class VaadinAccessControlAdapter
    implements BeforeEnterListener {
        private VaadinAccessControlAdapter() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            ((RouteAccessControl)Instantiator.get((UI)event.getUI()).getOrCreate(RouteAccessControl.class)).checkAccess(event);
        }
    }
}

