/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.access.route;

import com.vaadin.flow.server.VaadinSession;
import de.codecamp.vaadin.security.spring.access.AccessRule;
import de.codecamp.vaadin.security.spring.access.route.AbstractRouteAccessRuleRegistry;
import de.codecamp.vaadin.security.spring.access.route.ApplicationRouteAccessRuleRegistry;
import java.util.Objects;
import java.util.Optional;

public class SessionRouteAccessRuleRegistry
extends AbstractRouteAccessRuleRegistry {
    private VaadinSession session;

    public SessionRouteAccessRuleRegistry(VaadinSession session) {
        this.session = session;
    }

    public static SessionRouteAccessRuleRegistry getSessionRegistry(VaadinSession session) {
        Objects.requireNonNull(session, "session must not be null");
        SessionRouteAccessRuleRegistry registry = (SessionRouteAccessRuleRegistry)session.getAttribute(SessionRouteAccessRuleRegistry.class);
        if (registry == null) {
            registry = new SessionRouteAccessRuleRegistry(session);
            session.setAttribute(SessionRouteAccessRuleRegistry.class, (Object)registry);
        }
        return registry;
    }

    @Override
    public Optional<AccessRule> getAccessRule(String routePath) {
        Optional<AccessRule> accessRuleOpt = super.getAccessRule(routePath);
        if (accessRuleOpt.isPresent()) {
            return accessRuleOpt;
        }
        return this.getApplicationRegistry().getAccessRule(routePath);
    }

    @Override
    public Optional<AccessRule> getAccessRule(Class<?> targetOrLayout) {
        Optional<AccessRule> accessRuleOpt = super.doGetAccessRule(targetOrLayout, false);
        if (accessRuleOpt.isPresent()) {
            return accessRuleOpt;
        }
        return this.getApplicationRegistry().getAccessRule(targetOrLayout);
    }

    private AbstractRouteAccessRuleRegistry getApplicationRegistry() {
        return ApplicationRouteAccessRuleRegistry.getApplicationRegistry(this.session.getService().getContext());
    }
}

