/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.server.VaadinSession;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationService;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractAuthenticationSuccessFailureHandler {
    private static final Logger LOG = LoggerFactory.getLogger(VaadinAuthenticationService.class);

    AbstractAuthenticationSuccessFailureHandler() {
    }

    protected Optional<VaadinSession> getSession(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            LOG.warn("No HttpSession found to store VaadinAuthenticationResult.");
            return Optional.empty();
        }
        Collection sessions = VaadinSession.getAllSessions((HttpSession)httpSession);
        if (sessions.size() > 1) {
            throw new IllegalStateException("Multiple VaadinSessions (caused by multiple VaadinServlets) not supported.");
        }
        VaadinSession session = sessions.stream().findFirst().orElse(null);
        if (session == null) {
            LOG.warn("No VaadinSession found for HttpServletRequest.");
        }
        return Optional.ofNullable(session);
    }
}

