/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinSession;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationChangeEvent;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationChangeObserver;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.authentication.event.InteractiveAuthenticationSuccessEvent;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class AuthenticationChangeDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationChangeDispatcher.class);

    @EventListener(value={AuthenticationSuccessEvent.class, InteractiveAuthenticationSuccessEvent.class})
    public void handleAuthenticationSuccess(AbstractAuthenticationEvent authenticationSuccessEvent) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            LOG.warn("Failed to deliver AuthenticationChangeEvent. No current request context found.");
            return;
        }
        HttpServletRequest httpRequest = requestAttributes.getRequest();
        this.getVaadinSession(httpRequest).ifPresent(session -> this.fireAuthenticationChangeEvent((VaadinSession)session, authenticationSuccessEvent.getAuthentication()));
    }

    private Optional<VaadinSession> getVaadinSession(HttpServletRequest request) {
        HttpSession httpSession = request.getSession(false);
        if (httpSession == null) {
            return Optional.empty();
        }
        Collection sessions = VaadinSession.getAllSessions((HttpSession)httpSession);
        if (sessions.size() > 1) {
            throw new IllegalStateException("Multiple VaadinSessions (caused by multiple VaadinServlets) not supported.");
        }
        VaadinSession session = sessions.stream().findFirst().orElse(null);
        return Optional.ofNullable(session);
    }

    private void fireAuthenticationChangeEvent(VaadinSession session, Authentication authentication) {
        AuthenticationChangeEvent event = new AuthenticationChangeEvent(session, authentication);
        session.access((Command & Serializable)() -> {
            SecurityContext origContext = SecurityContextHolder.getContext();
            if (origContext.getAuthentication() == null) {
                SecurityContext newContext = SecurityContextHolder.createEmptyContext();
                newContext.setAuthentication(authentication);
                SecurityContextHolder.setContext((SecurityContext)newContext);
            } else {
                origContext = null;
            }
            session.getUIs().forEach(ui -> ui.accessSynchronously((Command & Serializable)() -> {
                ArrayList descendants = new ArrayList();
                EventUtil.inspectHierarchy((Element)ui.getElement(), descendants, element -> true);
                EventUtil.getImplementingComponents(descendants.stream(), AuthenticationChangeObserver.class).forEach(observer -> observer.authenticationChange(event));
            }));
            if (origContext != null) {
                SecurityContextHolder.setContext((SecurityContext)origContext);
            }
        });
    }
}

