/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.server.VaadinSession;
import java.util.Objects;
import java.util.Optional;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class VaadinSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static final ThreadLocal<SecurityContext> contextHolder = new ThreadLocal();

    public void clearContext() {
        contextHolder.remove();
    }

    public SecurityContext getContext() {
        SecurityContext context = Optional.ofNullable(contextHolder.get()).or(() -> this.getSecurityContextFromCurrentVaadinSession()).orElse(null);
        if (context == null) {
            context = this.createEmptyContext();
            contextHolder.set(context);
        }
        return context;
    }

    private Optional<SecurityContext> getSecurityContextFromCurrentVaadinSession() {
        VaadinSession vaadinSession = VaadinSession.getCurrent();
        if (vaadinSession == null || vaadinSession.getSession() == null) {
            return Optional.empty();
        }
        return VaadinSecurityContextHolderStrategy.getSecurityContextFromVaadinSession(vaadinSession);
    }

    public static Optional<SecurityContext> getSecurityContextFromVaadinSession(VaadinSession vaadinSession) {
        Objects.requireNonNull(vaadinSession, "vaadinSession must not be null");
        return Optional.ofNullable(vaadinSession.getSession().getAttribute("SPRING_SECURITY_CONTEXT")).filter(SecurityContext.class::isInstance).map(s -> (SecurityContext)s).or(() -> Optional.ofNullable((SecurityContext)vaadinSession.getAttribute(SecurityContext.class)));
    }

    public void setContext(SecurityContext context) {
        Assert.notNull((Object)context, (String)"Only non-null SecurityContext instances are permitted");
        contextHolder.set(context);
    }

    public SecurityContext createEmptyContext() {
        return new SecurityContextImpl();
    }
}

