/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.authentication;

import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEnterListener;
import com.vaadin.flow.router.ListenerPriority;
import com.vaadin.flow.server.UIInitEvent;
import com.vaadin.flow.server.UIInitListener;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class VaadinSecurityContextStorageUIInitListener
implements UIInitListener {
    private static final SecurityContextSessionBinder SECURITY_CONTEXT_SESSION_BINDER = new SecurityContextSessionBinder();

    public void uiInit(UIInitEvent event) {
        event.getUI().addBeforeEnterListener((BeforeEnterListener)SECURITY_CONTEXT_SESSION_BINDER);
    }

    @ListenerPriority(value=0x7FFFFFFF)
    private static class SecurityContextSessionBinder
    implements BeforeEnterListener {
        private SecurityContextSessionBinder() {
        }

        public void beforeEnter(BeforeEnterEvent event) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (securityContext.getAuthentication() != null && securityContext.getAuthentication() instanceof AnonymousAuthenticationToken) {
                event.getUI().getSession().setAttribute(SecurityContext.class, (Object)securityContext);
            } else {
                event.getUI().getSession().setAttribute(SecurityContext.class, null);
            }
        }
    }
}

