/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.autoconfigure;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import de.codecamp.vaadin.security.spring.access.DefaultVaadinSecurityExpressionHandler;
import de.codecamp.vaadin.security.spring.access.VaadinSecurityExpressionHandler;
import de.codecamp.vaadin.security.spring.access.route.DefaultRouteAccessControl;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessControlServiceInitListener;
import de.codecamp.vaadin.security.spring.access.route.RouteAccessDeniedHandler;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationChangeDispatcher;
import de.codecamp.vaadin.security.spring.authentication.AuthenticationResultHandler;
import de.codecamp.vaadin.security.spring.authentication.StandardAuthenticationHandlers;
import de.codecamp.vaadin.security.spring.authentication.StandardAuthenticationService;
import de.codecamp.vaadin.security.spring.authentication.StandardAuthenticationServiceInitListener;
import de.codecamp.vaadin.security.spring.authentication.VaadinSecurityContextStorageUIInitListener;
import de.codecamp.vaadin.security.spring.autoconfigure.VaadinSecurityProperties;
import de.codecamp.vaadin.security.spring.config.VaadinSecurityConfigurer;
import dev.hilla.auth.EndpointAccessChecker;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.security.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={SecurityAutoConfiguration.class})
@EnableConfigurationProperties
public class VaadinSecurityAutoConfiguration {
    @Bean
    VaadinSecurityProperties vaadinSecurityProperties() {
        return new VaadinSecurityProperties();
    }

    @Bean
    AuthenticationChangeDispatcher vaadinSecurityAuthenticationChangeDispatcher() {
        return new AuthenticationChangeDispatcher();
    }

    @Bean
    VaadinSecurityContextStorageUIInitListener vaadinSecurityContextStorageUIInitListener() {
        return new VaadinSecurityContextStorageUIInitListener();
    }

    @Bean
    @ConditionalOnProperty(prefix="codecamp.vaadin.security.standard-auth", name={"enabled"}, matchIfMissing=true)
    StandardAuthenticationService vaadinStandardAuthenticationService(List<AuthenticationResultHandler> authenticationResultHandler, VaadinSecurityProperties properties) {
        StandardAuthenticationService bean = new StandardAuthenticationService();
        URI uiRootUrl = URI.create(properties.getUiRootUrl());
        URI loginProcessingUrl = URI.create(properties.getStandardAuth().getLoginProcessingUrl());
        URI logoutProcessingUrl = URI.create(properties.getStandardAuth().getLogoutProcessingUrl());
        bean.setLoginProcessingClientUrl(uiRootUrl.relativize(loginProcessingUrl).toString());
        bean.setLogoutProcessingClientUrl(uiRootUrl.relativize(logoutProcessingUrl).toString());
        bean.setAuthenticationResultHandlers(authenticationResultHandler);
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="codecamp.vaadin.security.standard-auth", name={"enabled"}, matchIfMissing=true)
    StandardAuthenticationHandlers vaadinStandardAuthenticationHandlers(VaadinSecurityProperties properties) {
        StandardAuthenticationHandlers bean = new StandardAuthenticationHandlers();
        bean.setMainRoute(properties.getStandardAuth().getMainRoute());
        bean.setLoginRoute(properties.getStandardAuth().getLoginRoute());
        return bean;
    }

    @Bean
    @ConditionalOnProperty(prefix="codecamp.vaadin.security.standard-auth", name={"enabled"}, matchIfMissing=true)
    StandardAuthenticationServiceInitListener vaadinLoginRouteAccessRuleServiceInitListener(VaadinSecurityProperties properties) {
        StandardAuthenticationServiceInitListener bean = new StandardAuthenticationServiceInitListener();
        bean.setLoginRoute(properties.getStandardAuth().getLoginRoute());
        bean.setMainRoute(properties.getStandardAuth().getMainRoute());
        return bean;
    }

    @Bean
    @ConditionalOnMissingBean
    VaadinSecurityExpressionHandler vaadinSecurityExpressionHandler(Optional<RoleHierarchy> roleHierarchy) {
        DefaultVaadinSecurityExpressionHandler bean = new DefaultVaadinSecurityExpressionHandler();
        roleHierarchy.ifPresent(arg_0 -> ((DefaultVaadinSecurityExpressionHandler)bean).setRoleHierarchy(arg_0));
        return bean;
    }

    @Bean
    DefaultRouteAccessControl vaadinRouteAccessControl(List<RouteAccessDeniedHandler> vaadinRouteAccessDeniedHandlers, VaadinSecurityProperties properties) {
        DefaultRouteAccessControl bean = new DefaultRouteAccessControl();
        bean.setDenyUnsecured(properties.getDenyUnsecured());
        bean.setAccessDeniedHandlers(vaadinRouteAccessDeniedHandlers);
        return bean;
    }

    @Bean
    RouteAccessControlServiceInitListener vaadinRouteAccessControlServiceInitListener() {
        return new RouteAccessControlServiceInitListener();
    }

    @Bean
    @ConditionalOnDefaultWebSecurity
    @Order(value=0x7FFFFFFA)
    SecurityFilterChain defaultVaadinSecurityFilterChain(HttpSecurity http) throws Exception {
        http.apply((SecurityConfigurerAdapter)new VaadinSecurityConfigurer());
        return (SecurityFilterChain)http.build();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={EndpointAccessChecker.class})
    static class EndpointSecurityConfiguration {
        EndpointSecurityConfiguration() {
        }

        @Bean
        @Primary
        @ConditionalOnBean(value={AccessAnnotationChecker.class})
        EndpointAccessChecker vaadinSecurityEndpointAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
            return new de.codecamp.vaadin.security.spring.access.endpoint.EndpointAccessChecker(accessAnnotationChecker);
        }
    }
}

