/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.autoconfigure;

import com.vaadin.flow.spring.VaadinConfigurationProperties;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.validation.annotation.Validated;

@Validated
@ConfigurationProperties(prefix="codecamp.vaadin.security")
public class VaadinSecurityProperties {
    public static final String PREFIX = "codecamp.vaadin.security";
    @Autowired
    private VaadinConfigurationProperties vaadinProperties;
    private String uiRootUrl;
    private boolean denyUnsecured = false;
    @Valid
    @NestedConfigurationProperty
    private final StandardAuth standardAuth = new StandardAuth();

    public String getUiRootUrl() {
        if (StringUtils.isBlank((CharSequence)this.uiRootUrl)) {
            this.uiRootUrl = StringUtils.stripEnd((String)this.vaadinProperties.getUrlMapping(), (String)"/*");
        }
        return this.uiRootUrl;
    }

    public boolean getDenyUnsecured() {
        return this.denyUnsecured;
    }

    public void setDenyUnsecured(boolean denyUnsecured) {
        this.denyUnsecured = denyUnsecured;
    }

    public StandardAuth getStandardAuth() {
        return this.standardAuth;
    }

    public class StandardAuth {
        private boolean enabled = true;
        private String mainRoute = "";
        private String loginRoute = "login";
        private String loginProcessingUrl;
        private String logoutProcessingUrl;
        private String logoutSuccessUrl;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getMainRoute() {
            return this.mainRoute;
        }

        public void setMainRoute(String mainRoute) {
            this.mainRoute = mainRoute;
        }

        public String getLoginRoute() {
            return this.loginRoute;
        }

        public void setLoginRoute(String loginRoute) {
            this.loginRoute = loginRoute;
        }

        public String getLoginProcessingUrl() {
            if (StringUtils.isBlank((CharSequence)this.loginProcessingUrl)) {
                this.loginProcessingUrl = VaadinSecurityProperties.this.getUiRootUrl() + "/" + this.getLoginRoute();
            }
            return this.loginProcessingUrl;
        }

        public String getLogoutProcessingUrl() {
            if (StringUtils.isBlank((CharSequence)this.logoutProcessingUrl)) {
                this.logoutProcessingUrl = VaadinSecurityProperties.this.getUiRootUrl() + "/logout";
            }
            return this.logoutProcessingUrl;
        }

        public String getLogoutSuccessUrl() {
            if (StringUtils.isBlank((CharSequence)this.logoutSuccessUrl)) {
                this.logoutSuccessUrl = VaadinSecurityProperties.this.getUiRootUrl() + "/" + this.getMainRoute();
            }
            return this.logoutSuccessUrl;
        }

        public void setLogoutSuccessUrl(String logoutSuccessUrl) {
            this.logoutSuccessUrl = logoutSuccessUrl;
        }
    }
}

