/*
 * Decompiled with CFR 0.152.
 */
package de.codecamp.vaadin.security.spring.config;

import com.vaadin.flow.spring.security.RequestUtil;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationFailureHandler;
import de.codecamp.vaadin.security.spring.authentication.VaadinAuthenticationSuccessHandler;
import de.codecamp.vaadin.security.spring.authentication.VaadinSecurityContextHolderStrategy;
import de.codecamp.vaadin.security.spring.autoconfigure.VaadinSecurityProperties;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class VaadinSecurityConfigurer
extends AbstractHttpConfigurer<VaadinSecurityConfigurer, HttpSecurity> {
    private boolean configured = false;

    public void init(HttpSecurity http) throws Exception {
        this.doConfigure(http);
    }

    public void configure(HttpSecurity http) throws Exception {
        this.doConfigure(http);
    }

    private void doConfigure(HttpSecurity http) throws Exception {
        if (this.configured) {
            return;
        }
        SecurityContextHolder.setStrategyName((String)VaadinSecurityContextHolderStrategy.class.getName());
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        VaadinSecurityProperties properties = (VaadinSecurityProperties)applicationContext.getBean(VaadinSecurityProperties.class);
        RequestUtil requestUtil = (RequestUtil)applicationContext.getBean(RequestUtil.class);
        ArrayList<Object> rootPatterns = new ArrayList<Object>();
        if (properties.getUiRootUrl().isEmpty()) {
            rootPatterns.add("/**");
        } else {
            rootPatterns.add("/VAADIN/**");
            rootPatterns.add(properties.getUiRootUrl());
            rootPatterns.add(properties.getUiRootUrl() + "/**");
        }
        String[] rootPatternsArray = (String[])rootPatterns.toArray(String[]::new);
        RequestMatcher[] requestMatcherArray = new RequestMatcher[1];
        requestMatcherArray[0] = arg_0 -> ((RequestUtil)requestUtil).isFrameworkInternalRequest(arg_0);
        RequestMatcher[] requestMatcherArray2 = new RequestMatcher[1];
        requestMatcherArray2[0] = arg_0 -> ((RequestUtil)requestUtil).isEndpointRequest(arg_0);
        ((HttpSecurity.RequestMatcherConfigurer)((HttpSecurity.RequestMatcherConfigurer)http.requestMatchers().requestMatchers(requestMatcherArray)).requestMatchers(requestMatcherArray2)).antMatchers(rootPatternsArray);
        RequestMatcher[] requestMatcherArray3 = new RequestMatcher[1];
        requestMatcherArray3[0] = arg_0 -> ((RequestUtil)requestUtil).isFrameworkInternalRequest(arg_0);
        RequestMatcher[] requestMatcherArray4 = new RequestMatcher[1];
        requestMatcherArray4[0] = arg_0 -> ((RequestUtil)requestUtil).isEndpointRequest(arg_0);
        http.csrf().ignoringRequestMatchers(requestMatcherArray3).ignoringRequestMatchers(requestMatcherArray4).ignoringAntMatchers(rootPatternsArray);
        VaadinSecurityProperties.StandardAuth standardAuthProperties = properties.getStandardAuth();
        if (standardAuthProperties.isEnabled()) {
            ((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginProcessingUrl(standardAuthProperties.getLoginProcessingUrl())).successHandler((AuthenticationSuccessHandler)new VaadinAuthenticationSuccessHandler())).failureHandler((AuthenticationFailureHandler)new VaadinAuthenticationFailureHandler());
            http.logout().logoutUrl(standardAuthProperties.getLogoutProcessingUrl()).logoutSuccessUrl((String)StringUtils.defaultIfBlank((CharSequence)standardAuthProperties.getLogoutSuccessUrl(), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)properties.getUiRootUrl(), (CharSequence)"/"))));
        }
        this.configured = true;
    }
}

