/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="batch")
public class BatchConfigurationProperties {
    private JobConfigurationProperties config = new JobConfigurationProperties();
    private Toggle defaultProtocol = new Toggle(true);
    private Toggle logfileSeparation = new Toggle(true);
    private RepositoryConfigurationProperties repository = new RepositoryConfigurationProperties();
    private TaskExecutorProperties taskExecutor = new TaskExecutorProperties();

    public Toggle getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public Toggle getLogfileSeparation() {
        return this.logfileSeparation;
    }

    public JobConfigurationProperties getConfig() {
        return this.config;
    }

    public RepositoryConfigurationProperties getRepository() {
        return this.repository;
    }

    public TaskExecutorProperties getTaskExecutor() {
        return this.taskExecutor;
    }

    public static class Toggle {
        private boolean enabled;

        public Toggle(boolean enabled) {
            this.enabled = enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class RepositoryConfigurationProperties {
        private String isolationLevelForCreate = null;
        private String tablePrefix = null;

        public void setIsolationLevelForCreate(String isolationLevelForCreate) {
            this.isolationLevelForCreate = isolationLevelForCreate;
        }

        public String getIsolationLevelForCreate() {
            return this.isolationLevelForCreate;
        }

        public void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }
    }

    public static class JobConfigurationProperties {
        private String pathXml = "classpath*:/META-INF/spring/batch/jobs/*.xml";
        private String packageJavaconfig = "spring.batch.jobs";

        public void setPathXml(String pathXml) {
            this.pathXml = pathXml;
        }

        public String getPathXml() {
            return this.pathXml;
        }

        public void setPackageJavaconfig(String packageJavaconfig) {
            this.packageJavaconfig = packageJavaconfig;
        }

        public String getPackageJavaconfig() {
            return this.packageJavaconfig;
        }
    }

    public static class TaskExecutorProperties {
        private int corePoolSize = 5;
        private int queueCapacity = Integer.MAX_VALUE;
        private int maxPoolSize = Integer.MAX_VALUE;

        public int getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public int getQueueCapacity() {
            return this.queueCapacity;
        }

        public void setQueueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
        }

        public int getMaxPoolSize() {
            return this.maxPoolSize;
        }

        public void setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
        }
    }
}

