/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.BatchConfigurationProperties;
import de.codecentric.batch.scheduling.concurrent.MdcThreadPoolTaskExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;

@Configuration
@ConditionalOnMissingBean(value={TaskExecutor.class})
public class TaskExecutorConfiguration {
    @Autowired
    private BatchConfigurationProperties batchConfig;

    @Bean
    public TaskExecutor taskExecutor() {
        MdcThreadPoolTaskExecutor taskExecutor = new MdcThreadPoolTaskExecutor();
        taskExecutor.setCorePoolSize(this.batchConfig.getTaskExecutor().getCorePoolSize());
        taskExecutor.setQueueCapacity(this.batchConfig.getTaskExecutor().getQueueCapacity());
        taskExecutor.setMaxPoolSize(this.batchConfig.getTaskExecutor().getMaxPoolSize());
        taskExecutor.afterPropertiesSet();
        return taskExecutor;
    }
}

