/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.jsr352;

import de.codecentric.batch.listener.AddListenerToJobService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import javax.batch.operations.BatchRuntimeException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobExecutionException;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.DuplicateJobException;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.jsr.JsrJobContextFactoryBean;
import org.springframework.batch.core.jsr.configuration.xml.JsrXmlApplicationContext;
import org.springframework.batch.core.jsr.launch.JsrJobOperator;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class CustomJsrJobOperator
extends JsrJobOperator {
    private static final String JSR_JOB_CONTEXT_BEAN_NAME = "jsr_jobContext";
    private ApplicationContext parentContext;
    private JobRepository jobRepository;
    private TaskExecutor taskExecutor;
    private JobParametersConverter jobParametersConverter;
    private static ExecutingJobRegistry jobRegistry = new ExecutingJobRegistry();
    private AddListenerToJobService addListenerToJobService;

    public CustomJsrJobOperator(JobExplorer jobExplorer, JobRepository jobRepository, JobParametersConverter jobParametersConverter, AddListenerToJobService addListenerToJobService, PlatformTransactionManager transactionManager) {
        super(jobExplorer, jobRepository, jobParametersConverter, transactionManager);
        this.jobRepository = jobRepository;
        this.jobParametersConverter = jobParametersConverter;
        this.addListenerToJobService = addListenerToJobService;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        super.setTaskExecutor(taskExecutor);
        this.taskExecutor = taskExecutor;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }

    public long start(String jobName, Properties params) throws JobStartException, JobSecurityException {
        JobExecution jobExecution;
        final JsrXmlApplicationContext batchContext = new JsrXmlApplicationContext(params);
        batchContext.setValidating(false);
        ClassPathResource batchXml = new ClassPathResource("/META-INF/batch.xml");
        String jobConfigurationLocation = "/META-INF/batch-jobs/" + jobName + ".xml";
        ClassPathResource jobXml = new ClassPathResource(jobConfigurationLocation);
        if (batchXml.exists()) {
            batchContext.load(new Resource[]{batchXml});
        }
        if (jobXml.exists()) {
            batchContext.load(new Resource[]{jobXml});
        }
        AbstractBeanDefinition beanDefinition = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.batch.core.jsr.JsrJobContextFactoryBean").getBeanDefinition();
        beanDefinition.setScope("singleton");
        batchContext.registerBeanDefinition(JSR_JOB_CONTEXT_BEAN_NAME, (BeanDefinition)beanDefinition);
        batchContext.setParent(this.parentContext);
        try {
            batchContext.refresh();
        }
        catch (BeanCreationException e) {
            throw new JobStartException((Throwable)e);
        }
        Assert.notNull((Object)jobName, (String)"The job name must not be null.");
        try {
            JobParameters jobParameters = this.jobParametersConverter.getJobParameters(params);
            String[] jobNames = batchContext.getBeanNamesForType(Job.class);
            if (jobNames == null || jobNames.length <= 0) {
                throw new BatchRuntimeException("No Job defined in current context");
            }
            JobInstance jobInstance = this.jobRepository.createJobInstance(jobNames[0], jobParameters);
            jobExecution = this.jobRepository.createJobExecution(jobInstance, jobParameters, jobConfigurationLocation);
        }
        catch (Exception e) {
            throw new JobStartException((Throwable)e);
        }
        try {
            final Semaphore semaphore = new Semaphore(1);
            final List exceptionHolder = Collections.synchronizedList(new ArrayList());
            semaphore.acquire();
            this.taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    JsrJobContextFactoryBean factoryBean = null;
                    try {
                        factoryBean = (JsrJobContextFactoryBean)batchContext.getBean("&jsr_jobContext");
                        factoryBean.setJobExecution(jobExecution);
                        AbstractJob job = (AbstractJob)batchContext.getBean(AbstractJob.class);
                        CustomJsrJobOperator.this.addListenerToJobService.addListenerToJob(job);
                        semaphore.release();
                        jobRegistry.register((Job)job, jobExecution);
                        job.execute(jobExecution);
                        jobRegistry.remove(jobExecution);
                    }
                    catch (Exception e) {
                        exceptionHolder.add(e);
                    }
                    finally {
                        if (factoryBean != null) {
                            factoryBean.close();
                        }
                        batchContext.close();
                        if (semaphore.availablePermits() == 0) {
                            semaphore.release();
                        }
                    }
                }
            });
            semaphore.acquire();
            if (exceptionHolder.size() > 0) {
                semaphore.release();
                throw new JobStartException((Throwable)exceptionHolder.get(0));
            }
        }
        catch (Exception e) {
            if (jobRegistry.exists(jobExecution.getId())) {
                jobRegistry.remove(jobExecution);
            }
            jobExecution.upgradeStatus(BatchStatus.FAILED);
            if (jobExecution.getExitStatus().equals((Object)ExitStatus.UNKNOWN)) {
                jobExecution.setExitStatus(ExitStatus.FAILED.addExitDescription((Throwable)e));
            }
            this.jobRepository.update(jobExecution);
            if (batchContext.isActive()) {
                batchContext.close();
            }
            throw new JobStartException((Throwable)e);
        }
        return jobExecution.getId();
    }

    private static class ExecutingJobRegistry {
        private Map<Long, Job> registry = new ConcurrentHashMap<Long, Job>();

        private ExecutingJobRegistry() {
        }

        public void register(Job job, JobExecution jobExecution) throws DuplicateJobException {
            if (this.registry.containsKey(jobExecution.getId())) {
                throw new DuplicateJobException("This job execution has already been registered");
            }
            this.registry.put(jobExecution.getId(), job);
        }

        public void remove(JobExecution jobExecution) {
            if (!this.registry.containsKey(jobExecution.getId())) {
                throw new NoSuchJobExecutionException("The job execution " + jobExecution.getId() + " was not found");
            }
            this.registry.remove(jobExecution.getId());
        }

        public boolean exists(long jobExecutionId) {
            return this.registry.containsKey(jobExecutionId);
        }
    }
}

