/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.metrics;

import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.Arrays;
import org.aspectj.lang.ProceedingJoinPoint;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.util.ClassUtils;

public abstract class AbstractBatchMetricsAspect {
    private MeterRegistry meterRegistry;

    public AbstractBatchMetricsAspect(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object profileMethod(ProceedingJoinPoint pjp) throws Throwable {
        Object object;
        Timer.Sample sample = Timer.start((MeterRegistry)this.meterRegistry);
        try {
            object = pjp.proceed();
        }
        catch (Throwable throwable) {
            sample.stop(this.meterRegistry.timer("batch.metrics", Arrays.asList(new ImmutableTag("context", this.getStepIdentifier()), new ImmutableTag("method", ClassUtils.getShortName(pjp.getTarget().getClass()) + "." + pjp.getSignature().getName()))));
            throw throwable;
        }
        sample.stop(this.meterRegistry.timer("batch.metrics", Arrays.asList(new ImmutableTag("context", this.getStepIdentifier()), new ImmutableTag("method", ClassUtils.getShortName(pjp.getTarget().getClass()) + "." + pjp.getSignature().getName()))));
        return object;
    }

    private String getStepIdentifier() {
        StepContext stepContext = StepSynchronizationManager.getContext();
        StepExecution stepExecution = StepSynchronizationManager.getContext().getStepExecution();
        return stepContext.getJobName() + "." + stepExecution.getStepName();
    }
}

