/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.scheduling.concurrent;

import java.util.Map;
import org.slf4j.MDC;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class MdcThreadPoolTaskExecutor
extends ThreadPoolTaskExecutor {
    private static final long serialVersionUID = 1L;
    private boolean useFixedContext = false;
    private Map<String, String> fixedContext;

    public MdcThreadPoolTaskExecutor() {
    }

    public MdcThreadPoolTaskExecutor(Map<String, String> fixedContext) {
        this.fixedContext = fixedContext;
        this.useFixedContext = fixedContext != null;
    }

    private Map<String, String> getContextForTask() {
        return this.useFixedContext ? this.fixedContext : MDC.getCopyOfContextMap();
    }

    public void execute(Runnable command) {
        super.execute(MdcThreadPoolTaskExecutor.wrap(command, this.getContextForTask()));
    }

    public static Runnable wrap(final Runnable runnable, final Map<String, String> context) {
        return new Runnable(){

            @Override
            public void run() {
                Map previous = MDC.getCopyOfContextMap();
                if (context == null) {
                    MDC.clear();
                } else {
                    MDC.setContextMap((Map)context);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (previous == null) {
                        MDC.clear();
                    } else {
                        MDC.setContextMap((Map)previous);
                    }
                }
            }
        };
    }
}

