/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.AutomaticJobRegistrarConfiguration;
import de.codecentric.batch.configuration.BatchConfigurationProperties;
import de.codecentric.batch.configuration.Jsr352BatchConfiguration;
import de.codecentric.batch.configuration.MetricsConfiguration;
import de.codecentric.batch.configuration.TaskExecutorBatchConfiguration;
import de.codecentric.batch.configuration.TaskExecutorConfiguration;
import de.codecentric.batch.configuration.WebConfig;
import de.codecentric.batch.listener.AddListenerToJobService;
import de.codecentric.batch.listener.LoggingAfterJobListener;
import de.codecentric.batch.listener.LoggingListener;
import de.codecentric.batch.listener.ProtocolListener;
import de.codecentric.batch.listener.RunningExecutionTrackerListener;
import de.codecentric.batch.monitoring.RunningExecutionTracker;
import org.springframework.batch.core.configuration.JobRegistry;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.job.AbstractJob;
import org.springframework.batch.core.launch.NoSuchJobException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

@Configuration
@EnableBatchProcessing(modular=true)
@PropertySource(value={"classpath:batch-web-spring-boot-autoconfigure.properties"})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@Import(value={WebConfig.class, TaskExecutorBatchConfiguration.class, AutomaticJobRegistrarConfiguration.class, Jsr352BatchConfiguration.class, MetricsConfiguration.class, TaskExecutorConfiguration.class})
@EnableConfigurationProperties(value={BatchConfigurationProperties.class})
public class BatchWebAutoConfiguration
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    @Autowired
    private BatchConfigurationProperties batchConfig;
    @Autowired
    private JobRegistry jobRegistry;

    @Bean
    public LoggingListener loggingListener() {
        return new LoggingListener();
    }

    @Bean
    public LoggingAfterJobListener loggingAfterJobListener() {
        return new LoggingAfterJobListener();
    }

    @Bean
    public ProtocolListener protocolListener() {
        return new ProtocolListener();
    }

    @Bean
    public RunningExecutionTracker runningExecutionTracker() {
        return new RunningExecutionTracker();
    }

    @Bean
    public RunningExecutionTrackerListener runningExecutionTrackerListener() {
        return new RunningExecutionTrackerListener(this.runningExecutionTracker());
    }

    @Bean
    public AddListenerToJobService addListenerToJobService() {
        boolean addProtocolListener = this.batchConfig.getDefaultProtocol().isEnabled();
        boolean addLoggingListener = this.batchConfig.getLogfileSeparation().isEnabled();
        return new AddListenerToJobService(addProtocolListener, addLoggingListener, this.protocolListener(), this.runningExecutionTrackerListener(), this.loggingListener(), this.loggingAfterJobListener());
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.jobRegistry.getJobNames().forEach(jobName -> {
            try {
                AbstractJob job = (AbstractJob)this.jobRegistry.getJob(jobName);
                this.addListenerToJobService().addListenerToJob(job);
            }
            catch (NoSuchJobException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    @Bean
    @ConditionalOnMissingBean
    public JobParametersConverter jobParametersConverter() {
        return new DefaultJobParametersConverter();
    }
}

