/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.batch.configuration;

import de.codecentric.batch.configuration.BatchConfigurationProperties;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.BatchConfigurer;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.explore.support.JobExplorerFactoryBean;
import org.springframework.batch.core.explore.support.MapJobExplorerFactoryBean;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.batch.core.repository.support.MapJobRepositoryFactoryBean;
import org.springframework.batch.support.transaction.ResourcelessTransactionManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;

@ConditionalOnMissingBean(value={BatchConfigurer.class})
@Configuration
public class TaskExecutorBatchConfiguration
implements BatchConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskExecutorBatchConfiguration.class);
    @Autowired
    private BatchConfigurationProperties batchConfig;
    @Autowired
    private TaskExecutor taskExecutor;
    private DataSource dataSource;
    private PlatformTransactionManager transactionManager;
    private JobRepository jobRepository;
    private JobLauncher jobLauncher;
    private JobExplorer jobExplorer;
    @Autowired(required=false)
    private ExecutionContextSerializer serializer;

    @Autowired
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public JobRepository getJobRepository() {
        return this.jobRepository;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JobLauncher getJobLauncher() {
        return this.jobLauncher;
    }

    public JobExplorer getJobExplorer() throws Exception {
        return this.jobExplorer;
    }

    private JobLauncher createJobLauncher() throws Exception {
        SimpleJobLauncher simpleJobLauncher = new SimpleJobLauncher();
        simpleJobLauncher.setJobRepository(this.jobRepository);
        simpleJobLauncher.setTaskExecutor(this.taskExecutor);
        simpleJobLauncher.afterPropertiesSet();
        return simpleJobLauncher;
    }

    protected JobRepository createJobRepository() throws Exception {
        String tablePrefix;
        JobRepositoryFactoryBean factory = new JobRepositoryFactoryBean();
        factory.setDataSource(this.dataSource);
        factory.setTransactionManager(this.transactionManager);
        factory.setSerializer(this.serializer);
        String isolationLevelForCreate = this.batchConfig.getRepository().getIsolationLevelForCreate();
        if (isolationLevelForCreate != null) {
            factory.setIsolationLevelForCreate(isolationLevelForCreate);
        }
        if ((tablePrefix = this.batchConfig.getRepository().getTablePrefix()) != null) {
            factory.setTablePrefix(tablePrefix);
        }
        factory.afterPropertiesSet();
        return factory.getObject();
    }

    @PostConstruct
    public void initialize() throws Exception {
        if (this.dataSource == null) {
            LOGGER.warn("No datasource was provided...using a Map based JobRepository");
            if (this.transactionManager == null) {
                this.transactionManager = new ResourcelessTransactionManager();
            }
            MapJobRepositoryFactoryBean jobRepositoryFactory = new MapJobRepositoryFactoryBean(this.transactionManager);
            jobRepositoryFactory.afterPropertiesSet();
            this.jobRepository = jobRepositoryFactory.getObject();
            MapJobExplorerFactoryBean jobExplorerFactory = new MapJobExplorerFactoryBean(jobRepositoryFactory);
            jobExplorerFactory.afterPropertiesSet();
            this.jobExplorer = jobExplorerFactory.getObject();
        } else {
            if (this.transactionManager == null) {
                this.transactionManager = new DataSourceTransactionManager(this.dataSource);
            }
            this.jobRepository = this.createJobRepository();
            JobExplorerFactoryBean jobExplorerFactoryBean = new JobExplorerFactoryBean();
            jobExplorerFactoryBean.setDataSource(this.dataSource);
            jobExplorerFactoryBean.setSerializer(this.serializer);
            String tablePrefix = this.batchConfig.getRepository().getTablePrefix();
            if (tablePrefix != null) {
                jobExplorerFactoryBean.setTablePrefix(tablePrefix);
            }
            jobExplorerFactoryBean.afterPropertiesSet();
            this.jobExplorer = jobExplorerFactoryBean.getObject();
        }
        this.jobLauncher = this.createJobLauncher();
    }
}

