/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.component;

import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRequestAssault;
import de.codecentric.spring.boot.chaos.monkey.assaults.ChaosMonkeyRuntimeAssault;
import de.codecentric.spring.boot.chaos.monkey.component.MetricEventPublisher;
import de.codecentric.spring.boot.chaos.monkey.component.MetricType;
import de.codecentric.spring.boot.chaos.monkey.configuration.ChaosMonkeySettings;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ChaosMonkeyRequestScope {
    private final ChaosMonkeySettings chaosMonkeySettings;
    private final List<ChaosMonkeyRequestAssault> assaults;
    private MetricEventPublisher metricEventPublisher;

    public ChaosMonkeyRequestScope(ChaosMonkeySettings chaosMonkeySettings, List<ChaosMonkeyRequestAssault> assaults, List<ChaosMonkeyAssault> legacyAssaults, MetricEventPublisher metricEventPublisher) {
        List assaultAdapters = legacyAssaults.stream().filter(it -> !(it instanceof ChaosMonkeyRequestAssault) && !(it instanceof ChaosMonkeyRuntimeAssault)).map(chaosMonkeyAssault -> new RequestAssaultAdapter((ChaosMonkeyAssault)chaosMonkeyAssault)).collect(Collectors.toList());
        ArrayList<ChaosMonkeyRequestAssault> requestAssaults = new ArrayList<ChaosMonkeyRequestAssault>();
        requestAssaults.addAll(assaults);
        requestAssaults.addAll(assaultAdapters);
        this.chaosMonkeySettings = chaosMonkeySettings;
        this.assaults = requestAssaults;
        this.metricEventPublisher = metricEventPublisher;
    }

    public void callChaosMonkey(String simpleName) {
        if (this.isEnabled() && this.isTrouble()) {
            if (this.metricEventPublisher != null) {
                this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "total");
            }
            if (this.chaosMonkeySettings.getAssaultProperties().isWatchedCustomServicesActive()) {
                if (this.chaosMonkeySettings.getAssaultProperties().getWatchedCustomServices().contains(simpleName)) {
                    this.chooseAndRunAttack();
                }
            } else {
                this.chooseAndRunAttack();
            }
        }
    }

    private void chooseAndRunAttack() {
        List<ChaosMonkeyAssault> activeAssaults = this.assaults.stream().filter(ChaosMonkeyAssault::isActive).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(activeAssaults)) {
            return;
        }
        this.getRandomFrom(activeAssaults).attack();
        if (this.metricEventPublisher != null) {
            this.metricEventPublisher.publishMetricEvent(MetricType.APPLICATION_REQ_COUNT, "type", "assaulted");
        }
    }

    private ChaosMonkeyAssault getRandomFrom(List<ChaosMonkeyAssault> activeAssaults) {
        int exceptionRand = this.chaosMonkeySettings.getAssaultProperties().chooseAssault(activeAssaults.size());
        return activeAssaults.get(exceptionRand);
    }

    private boolean isTrouble() {
        return this.chaosMonkeySettings.getAssaultProperties().getTroubleRandom() >= this.chaosMonkeySettings.getAssaultProperties().getLevel();
    }

    private boolean isEnabled() {
        return this.chaosMonkeySettings.getChaosMonkeyProperties().isEnabled();
    }

    private static class RequestAssaultAdapter
    implements ChaosMonkeyRequestAssault {
        private static final Logger LOGGER = LoggerFactory.getLogger(RequestAssaultAdapter.class);
        private final ChaosMonkeyAssault rawAssault;

        private RequestAssaultAdapter(ChaosMonkeyAssault rawAssault) {
            LOGGER.warn("Adapting a " + rawAssault.getClass().getSimpleName() + " into a request assault. The class should extend its proper parent");
            this.rawAssault = rawAssault;
        }

        @Override
        public boolean isActive() {
            return this.rawAssault.isActive();
        }

        @Override
        public void attack() {
            this.rawAssault.attack();
        }
    }
}

