/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.util.ClassUtils;

public class AssaultException {
    private static final Logger Logger = LoggerFactory.getLogger(AssaultException.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String CONSTRUCTOR = "<init>";
    @NotNull
    private String type = "java.lang.RuntimeException";
    @NotNull
    private String method = "<init>";
    @NotNull
    @NestedConfigurationProperty
    private List<ExceptionArgument> arguments = Collections.singletonList(new ExceptionArgument(String.class.getName(), "Chaos Monkey - RuntimeException"));

    @JsonIgnore
    public void throwExceptionInstance() {
        throw this.getThrowable();
    }

    @JsonIgnore
    private Throwable getThrowable() {
        Throwable instance;
        try {
            ThrowableCreator creator = this.getCreator();
            instance = creator.create(this.getExceptionArgumentValues());
        }
        catch (JsonProcessingException | ClassCastException | ReflectiveOperationException e) {
            Logger.warn("Failed to create custom exception. Fallback: Throw RuntimeException");
            instance = new RuntimeException("Chaos Monkey - RuntimeException (Fallback)", e);
        }
        return instance;
    }

    @JsonIgnore
    public ThrowableCreator getCreator() throws ReflectiveOperationException {
        Class<?> exceptionClass = this.getExceptionClass();
        Class[] argumentTypes = this.getExceptionArgumentTypes().toArray(new Class[0]);
        if (CONSTRUCTOR.equals(this.method)) {
            return new ThrowableConstructor(exceptionClass.asSubclass(Throwable.class).getConstructor(argumentTypes));
        }
        return new ThrowableStaticInitializer(exceptionClass.getMethod(this.method, argumentTypes));
    }

    @JsonIgnore
    public Class<?> getExceptionClass() throws ClassNotFoundException {
        return Class.forName(this.type);
    }

    private List<Class<?>> getExceptionArgumentTypes() throws ClassNotFoundException {
        ArrayList exceptionArgumentTypes = new ArrayList();
        for (ExceptionArgument argument : this.arguments) {
            exceptionArgumentTypes.add(argument.getClassType());
        }
        return exceptionArgumentTypes;
    }

    private List<Object> getExceptionArgumentValues() throws ClassNotFoundException, JsonProcessingException {
        ArrayList<Object> exceptionArgumentValues = new ArrayList<Object>();
        for (ExceptionArgument argument : this.arguments) {
            Class<?> classType = argument.getClassType();
            String value = argument.getValue();
            try {
                exceptionArgumentValues.add(objectMapper.convertValue((Object)value, classType));
            }
            catch (IllegalArgumentException e) {
                exceptionArgumentValues.add(objectMapper.readValue(value, classType));
            }
        }
        return exceptionArgumentValues;
    }

    @NotNull
    public String getType() {
        return this.type;
    }

    @NotNull
    public String getMethod() {
        return this.method;
    }

    @NotNull
    public List<ExceptionArgument> getArguments() {
        return this.arguments;
    }

    public void setType(@NotNull String type) {
        this.type = type;
    }

    public void setMethod(@NotNull String method) {
        this.method = method;
    }

    public void setArguments(@NotNull List<ExceptionArgument> arguments) {
        this.arguments = arguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultException)) {
            return false;
        }
        AssaultException other = (AssaultException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        List<ExceptionArgument> this$arguments = this.getArguments();
        List<ExceptionArgument> other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        List<ExceptionArgument> $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        return result;
    }

    public String toString() {
        return "AssaultException(type=" + this.getType() + ", method=" + this.getMethod() + ", arguments=" + this.getArguments() + ")";
    }

    private static class ThrowableStaticInitializer
    implements ThrowableCreator {
        private final Method initializer;

        @Override
        public Throwable create(List<?> arguments) throws ReflectiveOperationException {
            return (Throwable)this.initializer.invoke(null, arguments.toArray());
        }

        public ThrowableStaticInitializer(Method initializer) {
            this.initializer = initializer;
        }
    }

    private static class ThrowableConstructor
    implements ThrowableCreator {
        private final Constructor<? extends Throwable> constructor;

        @Override
        public Throwable create(List<?> arguments) throws ReflectiveOperationException {
            return this.constructor.newInstance(arguments.toArray());
        }

        public ThrowableConstructor(Constructor<? extends Throwable> constructor) {
            this.constructor = constructor;
        }
    }

    private static interface ThrowableCreator {
        public Throwable create(List<?> var1) throws ReflectiveOperationException;
    }

    public static class ExceptionArgument {
        @NotNull
        private String type;
        @NotNull
        private String value;

        @JsonIgnore
        public Class<?> getClassType() throws ClassNotFoundException {
            return ClassUtils.forName(this.type, null);
        }

        @NotNull
        public String getType() {
            return this.type;
        }

        @NotNull
        public String getValue() {
            return this.value;
        }

        public void setType(@NotNull String type) {
            this.type = type;
        }

        public void setValue(@NotNull String value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExceptionArgument)) {
                return false;
            }
            ExceptionArgument other = (ExceptionArgument)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExceptionArgument;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "AssaultException.ExceptionArgument(type=" + this.getType() + ", value=" + this.getValue() + ")";
        }

        public ExceptionArgument() {
        }

        public ExceptionArgument(@NotNull String type, @NotNull String value) {
            this.type = type;
            this.value = value;
        }
    }
}

