/*
 * Decompiled with CFR 0.152.
 */
package io.getunleash.repository;

import io.getunleash.FeatureToggle;
import io.getunleash.UnleashException;
import io.getunleash.event.UnleashEvent;
import io.getunleash.event.UnleashSubscriber;
import io.getunleash.lang.Nullable;
import io.getunleash.repository.ToggleCollection;
import java.util.Collections;
import java.util.List;

public final class FeatureToggleResponse
implements UnleashEvent {
    private final Status status;
    private final int httpStatusCode;
    private final ToggleCollection toggleCollection;
    @Nullable
    private String location;

    public FeatureToggleResponse(Status status, ToggleCollection toggleCollection) {
        this.status = status;
        this.httpStatusCode = 200;
        this.toggleCollection = toggleCollection;
    }

    public FeatureToggleResponse(Status status, int httpStatusCode) {
        this.status = status;
        this.httpStatusCode = httpStatusCode;
        List<FeatureToggle> emptyList = Collections.emptyList();
        this.toggleCollection = new ToggleCollection(emptyList);
    }

    public FeatureToggleResponse(Status status, int httpStatusCode, @Nullable String location) {
        this(status, httpStatusCode);
        this.location = location;
    }

    public Status getStatus() {
        return this.status;
    }

    public ToggleCollection getToggleCollection() {
        return this.toggleCollection;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    @Nullable
    public String getLocation() {
        return this.location;
    }

    public String toString() {
        return "FeatureToggleResponse: status=" + (Object)((Object)this.status) + " httpStatus=" + this.httpStatusCode + " location=" + this.location;
    }

    @Override
    public void publishTo(UnleashSubscriber unleashSubscriber) {
        if (this.status == Status.UNAVAILABLE) {
            String msg = "Error fetching toggles from Unleash API - StatusCode: " + this.getHttpStatusCode();
            if (this.location != null) {
                msg = msg + ", Location: " + this.location;
            }
            unleashSubscriber.onError(new UnleashException(msg, null));
        }
        unleashSubscriber.togglesFetched(this);
    }

    public static enum Status {
        NOT_CHANGED,
        CHANGED,
        UNAVAILABLE;

    }
}

