/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.endpoint.jmx;

import java.util.function.BiConsumer;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointProperties;
import org.springframework.boot.actuate.endpoint.jmx.EndpointObjectNameFactory;
import org.springframework.boot.actuate.endpoint.jmx.ExposableJmxEndpoint;
import org.springframework.boot.autoconfigure.jmx.JmxProperties;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class DefaultEndpointObjectNameFactory
implements EndpointObjectNameFactory {
    private final JmxEndpointProperties properties;
    private final JmxProperties jmxProperties;
    private final MBeanServer mBeanServer;
    private final String contextId;

    DefaultEndpointObjectNameFactory(JmxEndpointProperties properties, JmxProperties jmxProperties, MBeanServer mBeanServer, String contextId) {
        this.properties = properties;
        this.jmxProperties = jmxProperties;
        this.mBeanServer = mBeanServer;
        this.contextId = contextId;
    }

    @Override
    public ObjectName getObjectName(ExposableJmxEndpoint endpoint) throws MalformedObjectNameException {
        StringBuilder builder = new StringBuilder(this.determineDomain());
        builder.append(":type=Endpoint");
        builder.append(",name=").append(StringUtils.capitalize(endpoint.getEndpointId().toString()));
        String baseName = builder.toString();
        if (this.mBeanServer != null && this.hasMBean(baseName)) {
            builder.append(",context=").append(this.contextId);
        }
        if (this.jmxProperties.isUniqueNames()) {
            String identity = ObjectUtils.getIdentityHexString(endpoint);
            builder.append(",identity=").append(identity);
        }
        builder.append(this.getStaticNames());
        return ObjectNameManager.getInstance((String)builder.toString());
    }

    private String determineDomain() {
        if (StringUtils.hasText(this.properties.getDomain())) {
            return this.properties.getDomain();
        }
        if (StringUtils.hasText(this.jmxProperties.getDefaultDomain())) {
            return this.jmxProperties.getDefaultDomain();
        }
        return "org.springframework.boot";
    }

    private boolean hasMBean(String baseObjectName) throws MalformedObjectNameException {
        ObjectName query = new ObjectName(baseObjectName + ",*");
        return !this.mBeanServer.queryNames(query, null).isEmpty();
    }

    private String getStaticNames() {
        if (this.properties.getStaticNames().isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        this.properties.getStaticNames().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> builder.append(",").append(name).append("=").append(value)));
        return builder.toString();
    }
}

