/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.liquibase;

import liquibase.integration.spring.SpringLiquibase;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.autoconfigure.endpoint.condition.ConditionalOnAvailableEndpoint;
import org.springframework.boot.actuate.liquibase.LiquibaseEndpoint;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.liquibase.DataSourceClosingSpringLiquibase;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={LiquibaseAutoConfiguration.class})
@ConditionalOnClass(value={SpringLiquibase.class})
@ConditionalOnAvailableEndpoint(endpoint=LiquibaseEndpoint.class)
public class LiquibaseEndpointAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    @ConditionalOnMissingBean
    public LiquibaseEndpoint liquibaseEndpoint(ApplicationContext context) {
        return new LiquibaseEndpoint(context);
    }

    @Bean
    @ConditionalOnBean(value={SpringLiquibase.class})
    public static BeanPostProcessor preventDataSourceCloseBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DataSourceClosingSpringLiquibase) {
                    ((DataSourceClosingSpringLiquibase)((Object)bean)).setCloseDataSourceOnceMigrated(false);
                }
                return bean;
            }

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                return bean;
            }
        };
    }
}

