/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.web.server;

import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.web.reactive.context.ConfigurableReactiveWebApplicationContext;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

class OnManagementPortCondition
extends SpringBootCondition {
    private static final String CLASS_NAME_WEB_APPLICATION_CONTEXT = "org.springframework.web.context.WebApplicationContext";

    OnManagementPortCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition("Management Port", new Object[0]);
        if (!this.isWebApplicationContext(context)) {
            return ConditionOutcome.noMatch(message.because("non web application context"));
        }
        Map<String, Object> attributes = metadata.getAnnotationAttributes(ConditionalOnManagementPort.class.getName());
        ManagementPortType requiredType = (ManagementPortType)((Object)attributes.get("value"));
        ManagementPortType actualType = ManagementPortType.get(context.getEnvironment());
        if (actualType == requiredType) {
            return ConditionOutcome.match(message.because("actual port type (" + (Object)((Object)actualType) + ") matched required type"));
        }
        return ConditionOutcome.noMatch(message.because("actual port type (" + (Object)((Object)actualType) + ") did not match required type (" + (Object)((Object)requiredType) + ")"));
    }

    private boolean isWebApplicationContext(ConditionContext context) {
        ResourceLoader resourceLoader = context.getResourceLoader();
        if (resourceLoader instanceof ConfigurableReactiveWebApplicationContext) {
            return true;
        }
        if (!ClassUtils.isPresent(CLASS_NAME_WEB_APPLICATION_CONTEXT, context.getClassLoader())) {
            return false;
        }
        return resourceLoader instanceof WebApplicationContext;
    }
}

