/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.client;

import org.springframework.boot.web.client.RootUriTemplateHandler;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.web.util.DefaultUriBuilderFactory;
import org.springframework.web.util.UriTemplateHandler;

public class LocalHostUriTemplateHandler
extends RootUriTemplateHandler {
    private static final String PREFIX = "server.servlet.";
    private final Environment environment;
    private final String scheme;

    public LocalHostUriTemplateHandler(Environment environment) {
        this(environment, "http");
    }

    public LocalHostUriTemplateHandler(Environment environment, String scheme) {
        this(environment, scheme, (UriTemplateHandler)new DefaultUriBuilderFactory());
    }

    public LocalHostUriTemplateHandler(Environment environment, String scheme, UriTemplateHandler handler) {
        super(handler);
        Assert.notNull((Object)environment, "Environment must not be null");
        Assert.notNull((Object)scheme, "Scheme must not be null");
        this.environment = environment;
        this.scheme = scheme;
    }

    public String getRootUri() {
        String port = this.environment.getProperty("local.server.port", "8080");
        String contextPath = this.environment.getProperty("server.servlet.context-path", "");
        return this.scheme + "://localhost:" + port + contextPath;
    }
}

