/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.autodetection;

import de.codecentric.cxf.autodetection.PackageNameReader;
import de.codecentric.cxf.autodetection.WebServiceScanner;
import de.codecentric.cxf.autodetection.diagnostics.SeiImplClassNotFoundException;
import de.codecentric.cxf.autodetection.diagnostics.SeiNotFoundException;
import de.codecentric.cxf.autodetection.diagnostics.WebServiceClientNotFoundException;
import de.codecentric.cxf.common.BootStarterCxfException;
import javax.jws.WebService;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WebServiceAutoDetector {
    private static final Logger LOG = LoggerFactory.getLogger(WebServiceAutoDetector.class);
    protected static final String NO_CLASS_FOUND = "No class found";
    private final WebServiceScanner webServiceScanner;
    private final ApplicationContext applicationContext;
    public static final Class<WebService> SEI_ANNOTATION = WebService.class;
    public static final Class<WebServiceClient> WEB_SERVICE_CLIENT_ANNOTATION = WebServiceClient.class;
    private final String seiAndWebServiceClientPackageName;
    private final String seiImplementationPackageName;

    public WebServiceAutoDetector(WebServiceScanner webServiceScanner, ApplicationContext applicationContext) throws BootStarterCxfException {
        this.webServiceScanner = webServiceScanner;
        this.applicationContext = applicationContext;
        this.seiAndWebServiceClientPackageName = PackageNameReader.build().readSeiAndWebServiceClientPackageNameFromCxfSpringBootMavenProperties();
        this.seiImplementationPackageName = PackageNameReader.build().readSeiImplementationPackageNameFromCxfSpringBootMavenProperties();
    }

    public <T> T searchAndInstantiateSeiImplementation() throws BootStarterCxfException {
        return this.searchAndInstantiateSeiImplementation(this.searchServiceEndpointInterface());
    }

    protected <T> T searchAndInstantiateSeiImplementation(Class seiName) throws BootStarterCxfException {
        Class implementingClass = null;
        try {
            implementingClass = this.webServiceScanner.scanForClassWhichImplementsAndPickFirst(seiName, this.seiImplementationPackageName);
            LOG.info("Found SEI implementing class: '{}'", (Object)implementingClass.getName());
        }
        catch (BootStarterCxfException exception) {
            throw SeiImplClassNotFoundException.build().setNotFoundClassName(seiName.getName()).setScannedBasePackage(this.seiImplementationPackageName);
        }
        return this.instantiateFromClass(implementingClass);
    }

    public Class searchServiceEndpointInterface() throws BootStarterCxfException {
        try {
            Class sei = this.webServiceScanner.scanForClassWithAnnotationAndIsAnInterface(SEI_ANNOTATION, this.seiAndWebServiceClientPackageName);
            LOG.info("Found Service Endpoint Interface (SEI): '{}'", (Object)sei.getName());
            return sei;
        }
        catch (BootStarterCxfException exception) {
            throw new SeiNotFoundException();
        }
    }

    public Service searchAndInstantiateWebServiceClient() throws BootStarterCxfException {
        try {
            Class webServiceClientClass = this.webServiceScanner.scanForClassWithAnnotationAndPickTheFirstOneFound(WEB_SERVICE_CLIENT_ANNOTATION, this.seiAndWebServiceClientPackageName);
            LOG.info("Found WebServiceClient class: '{}'", (Object)webServiceClientClass.getName());
            return (Service)this.instantiateFromClass(webServiceClientClass);
        }
        catch (BootStarterCxfException exception) {
            throw new WebServiceClientNotFoundException();
        }
    }

    private <T> T instantiateFromClass(Class<T> clazz) throws BootStarterCxfException {
        try {
            return (T)this.applicationContext.getAutowireCapableBeanFactory().createBean(clazz);
        }
        catch (BeansException exception) {
            throw new BootStarterCxfException("Class couldn\u00b4t be instantiated", exception);
        }
    }
}

