/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.logging.soapmsg;

import de.codecentric.cxf.logging.BaseLogger;
import de.codecentric.cxf.logging.CxfLoggingSoapActionUtil;
import de.codecentric.cxf.logging.ElasticsearchField;
import java.util.logging.Logger;
import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingMessage;
import org.slf4j.MDC;

public class SoapMessageLoggingInInterceptor
extends LoggingInInterceptor {
    private static final BaseLogger LOG = BaseLogger.getLogger(SoapMessageLoggingInInterceptor.class);
    private boolean doLogging = false;
    private boolean doExtraction = false;

    protected void log(Logger logger, String message) {
        if (this.doLogging) {
            super.log(logger, message);
        } else if (this.doExtraction) {
            // empty if block
        }
    }

    protected String formatLoggingMessage(LoggingMessage loggingMessage) {
        String headers = loggingMessage.getHeader().toString();
        String soapMethodName = CxfLoggingSoapActionUtil.extractSoapMethodNameFromHttpHeader(headers);
        MDC.put((String)ElasticsearchField.SOAP_METHOD_LOG_NAME.getName(), (String)soapMethodName);
        if (this.logButDontExtract()) {
            return this.buildLogStatementWithSoapMessage(loggingMessage);
        }
        if (this.extractButDontLog()) {
            return this.extractSoapMessageForElasticSearchProcessing(loggingMessage, headers);
        }
        if (this.logAndExtract()) {
            this.extractSoapMessageForElasticSearchProcessing(loggingMessage, headers);
            return this.buildLogStatementWithSoapMessage(loggingMessage);
        }
        return "";
    }

    private String extractSoapMessageForElasticSearchProcessing(LoggingMessage loggingMessage, String headers) {
        if (loggingMessage.getPayload().length() > 0) {
            LOG.logInboundSoapMessage(loggingMessage.getPayload().toString());
        }
        LOG.logHttpHeader(headers);
        return "";
    }

    private String buildLogStatementWithSoapMessage(LoggingMessage loggingMessage) {
        StringBuilder buffer = new StringBuilder();
        if (loggingMessage.getPayload().length() > 0) {
            buffer.append("000 >>> Inbound Message:\n");
            buffer.append((CharSequence)loggingMessage.getPayload());
        }
        return buffer.toString();
    }

    private boolean logAndExtract() {
        return this.doLogging && this.doExtraction;
    }

    private boolean extractButDontLog() {
        return this.doExtraction && !this.doLogging;
    }

    private boolean logButDontExtract() {
        return this.doLogging && !this.doExtraction;
    }

    public void extractSoapMessage(boolean active) {
        this.doExtraction = active;
    }

    public void logSoapMessage(boolean active) {
        this.doLogging = active;
    }
}

