/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.common;

import de.codecentric.cxf.common.BootStarterCxfException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.jws.WebMethod;
import javax.xml.bind.JAXB;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static <T> T readSoapMessageFromStreamAndUnmarshallBody2Object(InputStream fileStream, Class<T> jaxbClass) throws BootStarterCxfException {
        T unmarshalledObject = null;
        try {
            Document soapMessage = XmlUtils.parseFileStream2Document(fileStream);
            unmarshalledObject = XmlUtils.getUnmarshalledObjectFromSoapMessage(soapMessage, jaxbClass);
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("Problem unmarshalling the JAXBObject " + jaxbClass.getSimpleName() + " from the SoapMessage.", exception);
        }
        return unmarshalledObject;
    }

    public static <T> T unmarshallXMLString(String xml, Class<T> jaxbClass) {
        return (T)JAXB.unmarshal((Reader)new StringReader(xml), jaxbClass);
    }

    public static <T> T getUnmarshalledObjectFromSoapMessage(Document httpBody, Class<T> jaxbClass) throws BootStarterCxfException {
        Object unmarshalledObject = null;
        try {
            String namespaceUri = XmlUtils.getNamespaceUriFromJaxbClass(jaxbClass);
            Node nodeFromSoapMessage = httpBody.getElementsByTagNameNS(namespaceUri, XmlUtils.getXmlTagNameFromJaxbClass(jaxbClass)).item(0);
            JAXBElement<T> jaxbElement = XmlUtils.unmarshallNode(nodeFromSoapMessage, jaxbClass);
            unmarshalledObject = jaxbElement.getValue();
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("The SoapMessage doesn\u00b4t contain a representation of the JAXBObject " + jaxbClass.getSimpleName(), exception);
        }
        return (T)unmarshalledObject;
    }

    public static <T> JAXBElement<T> unmarshallNode(Node node, Class<T> jaxbClassName) throws BootStarterCxfException {
        Objects.requireNonNull(node);
        JAXBElement jaxbElement = null;
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbClassName});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            jaxbElement = unmarshaller.unmarshal((Source)new DOMSource(node), jaxbClassName);
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("Problem unmarshalling the node into JAXBElement: " + exception.getMessage(), exception);
        }
        return jaxbElement;
    }

    public static <T> String getNamespaceUriFromJaxbClass(Class<T> jaxbClass) throws BootStarterCxfException {
        for (Annotation annotation : jaxbClass.getPackage().getAnnotations()) {
            if (annotation.annotationType() != XmlSchema.class) continue;
            return ((XmlSchema)annotation).namespace();
        }
        throw new BootStarterCxfException("namespaceUri not found -> Is it really a JAXB-Class, thats used to call the method?");
    }

    public static <T> String getXmlTagNameFromJaxbClass(Class<T> jaxbClass) {
        String xmlTagName = "";
        for (Annotation annotation : jaxbClass.getAnnotations()) {
            if (annotation.annotationType() != XmlRootElement.class) continue;
            xmlTagName = ((XmlRootElement)annotation).name();
            break;
        }
        return xmlTagName;
    }

    public static <T> String getSoapActionFromJaxWsServiceInterface(Class<T> jaxWsServiceInterfaceClass, String jaxWsServiceInvokedMethodName) throws BootStarterCxfException {
        Method method = null;
        try {
            method = jaxWsServiceInterfaceClass.getDeclaredMethod(jaxWsServiceInvokedMethodName, new Class[0]);
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("jaxWsServiceInvokedMethodName not found -> Is it really a Method of the JaxWsServiceInterfaceClass?");
        }
        return XmlUtils.getSoapActionAnnotationFromMethod(method);
    }

    public static <T> String getSoapActionFromJaxWsServiceInterface(Class<T> jaxWsServiceInterfaceClass) throws BootStarterCxfException {
        Method method = null;
        try {
            method = jaxWsServiceInterfaceClass.getDeclaredMethods()[0];
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("jaxWsServiceInvokedMethodName not found -> Is it really a Method of the JaxWsServiceInterfaceClass?");
        }
        return XmlUtils.getSoapActionAnnotationFromMethod(method);
    }

    private static String getSoapActionAnnotationFromMethod(Method method) throws BootStarterCxfException {
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation.annotationType() != WebMethod.class) continue;
            return ((WebMethod)annotation).action();
        }
        throw new BootStarterCxfException("SoapAction from JaxWsServiceInterface not found");
    }

    public static Document parseFileStream2Document(InputStream contentAsStream) throws BootStarterCxfException {
        Document parsedDoc = null;
        try {
            parsedDoc = XmlUtils.setUpDocumentBuilder().parse(contentAsStream);
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("Problem parsing InputStream into Document: " + exception.getMessage(), exception);
        }
        return parsedDoc;
    }

    private static DocumentBuilder setUpDocumentBuilder() throws BootStarterCxfException {
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BootStarterCxfException("Problem creating DocumentBuilder: " + parserConfigurationException.getMessage(), parserConfigurationException);
        }
        return documentBuilder;
    }

    public static Document marhallJaxbElement(Object jaxbElement) throws BootStarterCxfException {
        Document jaxbDoc = null;
        try {
            Marshaller marshaller = XmlUtils.setUpMarshaller(jaxbElement.getClass());
            jaxbDoc = XmlUtils.createNewDocument();
            marshaller.marshal(jaxbElement, (Node)jaxbDoc);
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("Problem marshalling the JAXBElement into the Document: " + exception.getMessage(), exception);
        }
        return jaxbDoc;
    }

    private static Document createNewDocument() throws BootStarterCxfException {
        return XmlUtils.setUpDocumentBuilder().newDocument();
    }

    private static <T> Marshaller setUpMarshaller(Class<T> jaxbElementClass) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbElementClass});
        return jaxbContext.createMarshaller();
    }

    public static Element appendAsChildElement2NewElement(Document document) throws BootStarterCxfException {
        Document docWithDocumentAsChild = XmlUtils.copyDocumentAsChildelementUnderNewDocument(document);
        return docWithDocumentAsChild.getDocumentElement();
    }

    private static Document copyDocumentAsChildelementUnderNewDocument(Document document) throws BootStarterCxfException {
        Document docWithDocumentAsChild = XmlUtils.createNewDocument();
        docWithDocumentAsChild.appendChild(docWithDocumentAsChild.createElement("root2kick"));
        Node importedNode = docWithDocumentAsChild.importNode(document.getDocumentElement(), true);
        docWithDocumentAsChild.getDocumentElement().appendChild(importedNode);
        return docWithDocumentAsChild;
    }
}

