/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.configuration;

import de.codecentric.cxf.autodetection.WebServiceAutoDetector;
import de.codecentric.cxf.autodetection.WebServiceScanner;
import de.codecentric.cxf.common.BootStarterCxfException;
import de.codecentric.cxf.configuration.SoapMessageLoggerConfiguration;
import de.codecentric.cxf.configuration.TimeLoggingConfiguration;
import de.codecentric.cxf.configuration.XmlValidationConfiguration;
import java.util.Map;
import javax.servlet.Servlet;
import javax.xml.ws.Endpoint;
import javax.xml.ws.Service;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.spring.SpringBus;
import org.apache.cxf.jaxws.EndpointImpl;
import org.apache.cxf.transport.servlet.CXFServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnClass(value={CXFServlet.class})
@PropertySource(value={"classpath:spring-boot-starter-cxf.properties"})
@Import(value={XmlValidationConfiguration.class, SoapMessageLoggerConfiguration.class, TimeLoggingConfiguration.class})
public class CxfAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CxfAutoConfiguration.class);
    @Value(value="${soap.service.base.url:/soap-api}")
    private String baseUrl;
    @Value(value="${soap.service.publishedEndpointUrl:NOT_SET}")
    private String publishedEndpointUrl;
    @Value(value="${cxf.servicelist.title:CXF SpringBoot Starter - service list}")
    private String serviceListTitle;
    private String serviceUrlEnding = null;
    private Object seiImplementation;

    @Bean
    public WebServiceAutoDetector webServiceAutoDetector(ApplicationContext applicationContext) throws BootStarterCxfException {
        return new WebServiceAutoDetector(new WebServiceScanner(), applicationContext);
    }

    @Bean
    @ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
    public ServletRegistrationBean cxfDispatcherServlet() {
        ServletRegistrationBean servletRegistrationBean = new ServletRegistrationBean((Servlet)new CXFServlet(), new String[]{this.baseUrl + "/*"});
        Map initParameters = servletRegistrationBean.getInitParameters();
        initParameters.put("service-list-title", this.serviceListTitle);
        return servletRegistrationBean;
    }

    @Bean(name={"cxf"})
    @ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
    public SpringBus springBus() {
        return new SpringBus();
    }

    @Bean
    @ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
    public Object seiImplementation() throws BootStarterCxfException {
        if (this.seiImplementation == null) {
            this.seiImplementation = this.webServiceAutoDetector(null).searchAndInstantiateSeiImplementation();
        }
        return this.seiImplementation;
    }

    @Bean
    @ConditionalOnProperty(name={"endpoint.autoinit"}, matchIfMissing=true)
    public Endpoint endpoint() throws BootStarterCxfException {
        LOG.info("Autodetection successful. Initializing javax.xml.ws.Endpoint based on " + this.seiImplementation().getClass().getName());
        EndpointImpl endpoint = new EndpointImpl((Bus)this.springBus(), this.seiImplementation());
        endpoint.setServiceName(this.webServiceClient().getServiceName());
        endpoint.setWsdlLocation(this.webServiceClient().getWSDLDocumentLocation().toString());
        if (this.publishedEndpointUrl.equals("NOT_SET")) {
            endpoint.setPublishedEndpointUrl(this.webServiceClient().getServiceName().getLocalPart());
        } else {
            endpoint.setPublishedEndpointUrl(this.publishedEndpointUrl);
        }
        endpoint.publish(this.serviceUrlEnding());
        return endpoint;
    }

    @Bean
    public Service webServiceClient() throws BootStarterCxfException {
        return this.webServiceAutoDetector(null).searchAndInstantiateWebServiceClient();
    }

    public String baseUrl() {
        return this.baseUrl;
    }

    public String serviceUrlEnding() throws BootStarterCxfException {
        if (this.serviceUrlEnding == null) {
            this.serviceUrlEnding = "/" + this.webServiceClient().getServiceName().getLocalPart();
        }
        return this.serviceUrlEnding;
    }

    public String baseAndServiceEndingUrl() throws BootStarterCxfException {
        return this.baseUrl() + this.serviceUrlEnding();
    }
}

