/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.assertobjectequals;

import de.codecentric.mule.assertobjectequals.ObjectComparator;
import de.codecentric.mule.assertobjectequals.PathOption;
import de.codecentric.mule.assertobjectequals.PathPattern;
import de.codecentric.mule.assertobjectequals.PathPatternParser;
import de.codecentric.mule.assertobjectequals.PatternBasedOptionsFactory;
import de.codecentric.mule.assertobjectequals.XmlCompareOption;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Diff;

public class AssertObjectEqualsConnector {
    public Object compareObjects(Object expected, Object actual, boolean containsOnlyOnMaps, boolean checkMapOrder, List<String> pathOptions) throws Exception {
        Object expectedObj = this.convert2Object(expected);
        Object actualObj = this.convert2Object(actual);
        ObjectComparator comparator = this.createComparator(containsOnlyOnMaps, checkMapOrder, pathOptions == null ? new ArrayList() : pathOptions);
        Collection<String> diff = comparator.compare(expectedObj, actualObj);
        if (!diff.isEmpty()) {
            StringBuilder message = new StringBuilder();
            for (String s : diff) {
                if (message.length() > 0) {
                    message.append(System.lineSeparator());
                }
                message.append(s);
            }
            throw new AssertionError(message);
        }
        return actualObj;
    }

    public Object compareXml(Object expected, Object actual, XmlCompareOption xmlCompareOption) {
        DiffBuilder diffBuilder = DiffBuilder.compare((Object)expected).withTest(actual);
        switch (xmlCompareOption) {
            case IGNORE_COMMENTS: {
                diffBuilder = diffBuilder.ignoreComments();
                break;
            }
            case IGNORE_WHITESPACE: {
                diffBuilder = diffBuilder.ignoreWhitespace();
                break;
            }
            case NORMALIZE_WHITESPACE: {
                diffBuilder = diffBuilder.normalizeWhitespace();
                break;
            }
            default: {
                throw new IllegalArgumentException("I forgot to implement for a new enum constant.");
            }
        }
        Diff diff = diffBuilder.build();
        if (diff.hasDifferences()) {
            throw new AssertionError((Object)diff.toString((ComparisonFormatter)new DefaultComparisonFormatter()));
        }
        return actual;
    }

    private ObjectComparator createComparator(boolean containsOnlyOnMaps, boolean checkMapOrder, List<String> pathOptionsStrings) {
        PathPatternParser ppp = new PathPatternParser();
        ArrayList<PathPattern> patterns = new ArrayList<PathPattern>();
        for (String pathOptionString : pathOptionsStrings) {
            patterns.add(ppp.parse(pathOptionString));
        }
        EnumSet<PathOption> rootOptions = EnumSet.noneOf(PathOption.class);
        if (containsOnlyOnMaps) {
            rootOptions.add(PathOption.CONTAINS_ONLY_ON_MAPS);
        }
        if (checkMapOrder) {
            rootOptions.add(PathOption.CHECK_MAP_ORDER);
        }
        PatternBasedOptionsFactory optionFactory = new PatternBasedOptionsFactory(rootOptions, patterns);
        return new ObjectComparator(optionFactory);
    }

    private Object convert2Object(Object value) throws JsonProcessingException, IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof InputStream) {
            return new ObjectMapper().reader(Object.class).readValue((InputStream)value);
        }
        if (value instanceof byte[]) {
            return new ObjectMapper().reader(Object.class).readValue((byte[])value);
        }
        if (value instanceof CharSequence) {
            String trimmed = ((CharSequence)value).toString().trim();
            if (trimmed.startsWith("[") || trimmed.startsWith("{")) {
                return new ObjectMapper().reader(Object.class).readValue(trimmed);
            }
            return value;
        }
        return value;
    }
}

