/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.assertobjectequals;

import de.codecentric.mule.assertobjectequals.ObjectCompareOptionsFactory;
import de.codecentric.mule.assertobjectequals.Path;
import de.codecentric.mule.assertobjectequals.PathOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ObjectComparator {
    private ObjectCompareOptionsFactory optionFactory;

    public ObjectComparator(ObjectCompareOptionsFactory optionFactory) {
        this.optionFactory = optionFactory;
    }

    public Collection<String> compare(Object expected, Object actual) {
        State state = new State(expected, actual);
        ArrayList<String> diffs = new ArrayList<String>();
        this.compare(state, diffs);
        return diffs;
    }

    private void compare(State state, Collection<String> diffs) {
        if (state.options.contains((Object)PathOption.IGNORE)) {
            return;
        }
        if (state.expected == null) {
            if (state.actual != null) {
                diffs.add("at '" + state.path + "', expected is null, actual " + state.actual);
            }
        } else if (state.actual == null) {
            diffs.add("at '" + state.path + "', expected " + state.expected + ", actual is null");
        } else {
            this.compareNonNullObjects(state, diffs);
        }
    }

    private void compareNonNullObjects(State state, Collection<String> diffs) {
        if (state.expected instanceof List) {
            if (state.actual instanceof List) {
                this.compareLists(state, diffs);
            } else {
                diffs.add("at '" + state.path + "', expected List, but found " + state.actual.getClass().getName());
            }
        } else if (state.expected instanceof Map) {
            if (state.actual instanceof Map) {
                this.compareMaps(state, diffs);
            }
        } else if (!state.expected.equals(state.actual)) {
            diffs.add("at '" + state.path + "', expected " + state.expected + ", but found " + state.actual);
        }
    }

    private void compareLists(State state, Collection<String> diffs) {
        List expected = (List)state.expected;
        List actual = (List)state.actual;
        if (expected.size() != actual.size()) {
            diffs.add("at '" + state.path + "', expected size " + expected.size() + ", actual " + actual.size());
            return;
        }
        int size = expected.size();
        Iterator eIter = expected.iterator();
        Iterator aIter = actual.iterator();
        for (int i = 0; i < size; ++i) {
            if (!eIter.hasNext()) {
                throw new RuntimeException("at '" + state.path + "', unexpected end of iteration at index " + i);
            }
            if (!aIter.hasNext()) {
                throw new RuntimeException("at '" + state.path + "', unexpected end of iteration at index " + i);
            }
            State nextState = state.listEntry(i, size, eIter.next(), aIter.next());
            this.compare(nextState, diffs);
        }
    }

    private void compareMaps(State state, Collection<String> diffs) {
        if (this.compareMapKeysOnly(state, diffs)) {
            return;
        }
        Map expected = (Map)state.expected;
        Map actual = (Map)state.actual;
        for (Map.Entry entry : expected.entrySet()) {
            Object expectedKey = entry.getKey();
            this.compare(state.mapEntry(expectedKey.toString(), entry.getValue(), actual.get(expectedKey)), diffs);
        }
    }

    private boolean compareMapKeysOnly(State state, Collection<String> diffs) {
        Map expected = (Map)state.expected;
        Map actual = (Map)state.actual;
        LinkedHashSet<Object> keys = new LinkedHashSet<Object>(expected.keySet());
        keys.removeAll(actual.keySet());
        if (!keys.isEmpty()) {
            diffs.add("at '" + state.path + "', objects missing in actual: " + this.collectionToString(keys));
            return true;
        }
        if (!state.options.contains((Object)PathOption.CONTAINS_ONLY_ON_MAPS)) {
            keys = new LinkedHashSet(actual.keySet());
            keys.removeAll(expected.keySet());
            if (!keys.isEmpty()) {
                diffs.add("at '" + state.path + "', objects missing in expected: " + this.collectionToString(keys));
                return true;
            }
        }
        if (state.options.contains((Object)PathOption.CHECK_MAP_ORDER)) {
            return this.checkOrder(state.path, expected.keySet(), actual.keySet(), diffs);
        }
        return false;
    }

    private boolean checkOrder(Path path, Set<Object> expectedKeys, Set<Object> actualKeysOrig, Collection<String> diffs) {
        LinkedHashSet<Object> actualKeys = new LinkedHashSet<Object>(actualKeysOrig);
        Iterator actualIter = actualKeys.iterator();
        while (actualIter.hasNext()) {
            if (expectedKeys.contains(actualIter.next())) continue;
            actualIter.remove();
        }
        if (expectedKeys.size() != actualKeys.size()) {
            throw new RuntimeException("at " + path + " unexpected size mismatch");
        }
        Iterator<Object> expectedIter = expectedKeys.iterator();
        actualIter = actualKeys.iterator();
        int size = expectedKeys.size();
        for (int i = 0; i < size; ++i) {
            Object aKey;
            if (!expectedIter.hasNext()) {
                throw new RuntimeException("at '" + path + "', unexpected of iteration at index " + i);
            }
            if (!actualIter.hasNext()) {
                throw new RuntimeException("at '" + path + "', unexpected  of iteration at index " + i);
            }
            Object eKey = expectedIter.next();
            if (eKey.equals(aKey = actualIter.next())) continue;
            diffs.add("at '" + path + "', expect key " + eKey + ", actual " + aKey);
            return true;
        }
        return false;
    }

    private String collectionToString(Set<Object> col) {
        StringBuilder sb = new StringBuilder();
        for (Object o : col) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(o.toString());
        }
        return sb.toString();
    }

    private class State {
        final Path path;
        final Object expected;
        final Object actual;
        final EnumSet<PathOption> options;

        private State(Path path, Object expected, Object actual, EnumSet<PathOption> options) {
            this.path = path;
            this.expected = expected;
            this.actual = actual;
            this.options = options;
        }

        public State(Object expected, Object actual) {
            this.path = new Path();
            this.expected = expected;
            this.actual = actual;
            this.options = ObjectComparator.this.optionFactory.createOptions(null, this.path);
        }

        public State listEntry(int listIndex, int listSize, Object expected, Object actual) {
            Path next = this.path.listEntry(listIndex, listSize);
            return new State(next, expected, actual, ObjectComparator.this.optionFactory.createOptions(this.options, next));
        }

        public State mapEntry(String key, Object expected, Object actual) {
            Path next = this.path.mapEntry(key);
            return new State(next, expected, actual, ObjectComparator.this.optionFactory.createOptions(this.options, next));
        }
    }
}

