/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.assertobjectequals;

import de.codecentric.mule.assertobjectequals.Path;
import de.codecentric.mule.assertobjectequals.PathOption;
import de.codecentric.mule.assertobjectequals.PatternEntry;
import java.util.Arrays;
import java.util.EnumSet;

public class PathPattern {
    private PatternEntry[] entries;
    private EnumSet<PathOption> options;

    public PathPattern(PatternEntry[] entries, EnumSet<PathOption> options) {
        this.entries = Arrays.copyOf(entries, entries.length);
        this.options = EnumSet.copyOf(options);
    }

    public int size() {
        return this.entries.length;
    }

    public PatternEntry getEntry(int index) {
        return this.entries[index];
    }

    public boolean matches(Path path) {
        return this.matches(path, this.entries.length - 1);
    }

    public EnumSet<PathOption> getOptions() {
        return this.options;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PatternEntry entry : this.entries) {
            sb.append(entry.toString());
        }
        return sb.toString();
    }

    private boolean matches(Path path, int start) {
        if (start == -1) {
            return path.isRoot();
        }
        PatternEntry pe = this.entries[start];
        if (path.isRoot()) {
            return pe.getType() == PatternEntry.PatternEntryType.WILDCARD_ANY && start == 0;
        }
        switch (pe.getType()) {
            case LIST: {
                return this.matchesList(path, pe) && this.matches(path.getPredecessor(), start - 1);
            }
            case MAP: {
                return this.matchesMap(path, pe) && this.matches(path.getPredecessor(), start - 1);
            }
            case WILDCARD_ONE: {
                return this.matches(path.getPredecessor(), start - 1);
            }
            case WILDCARD_ANY: {
                return this.matchesWildcardAny(path, start);
            }
        }
        throw new IllegalStateException("Unknown enum constant");
    }

    private boolean matchesList(Path path, PatternEntry pe) {
        if (!path.isList()) {
            return false;
        }
        if (pe.getListIndex() == null) {
            return true;
        }
        int index = pe.getListIndex();
        if (index >= 0 && path.getIndex() == index) {
            return true;
        }
        return index < 0 && path.getIndex() == path.getListSize() + index;
    }

    private boolean matchesMap(Path path, PatternEntry pe) {
        if (!path.isMap()) {
            return false;
        }
        return pe.getKeyPattern().matcher(path.getKey()).matches();
    }

    private boolean matchesWildcardAny(Path path, int start) {
        if (this.matches(path, start - 1)) {
            return true;
        }
        if (this.matches(path.getPredecessor(), start - 1)) {
            return true;
        }
        return this.matches(path.getPredecessor(), start);
    }
}

