
package de.codecentric.mule.assertobjectequals.generated.processors;

import de.codecentric.mule.assertobjectequals.AssertObjectEqualsConnector;
import de.codecentric.mule.assertobjectequals.generated.adapters.AssertObjectEqualsConnectorProcessAdapter;
import java.util.List;
import javax.annotation.Generated;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationException;
import org.mule.api.devkit.ProcessAdapter;
import org.mule.api.devkit.ProcessTemplate;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.common.DefaultResult;
import org.mule.common.FailureType;
import org.mule.common.Result;
import org.mule.common.metadata.ConnectorMetaDataEnabled;
import org.mule.common.metadata.DefaultMetaData;
import org.mule.common.metadata.DefaultMetaDataKey;
import org.mule.common.metadata.DefaultPojoMetaDataModel;
import org.mule.common.metadata.DefaultSimpleMetaDataModel;
import org.mule.common.metadata.MetaData;
import org.mule.common.metadata.MetaDataKey;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.OperationMetaDataEnabled;
import org.mule.common.metadata.datatype.DataType;
import org.mule.common.metadata.datatype.DataTypeFactory;
import org.mule.devkit.api.transformer.TransformingValue;
import org.mule.devkit.internal.metadata.fixes.STUDIO7157;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.callback.ProcessCallback;


/**
 * CompareObjectsMessageProcessor invokes the {@link de.codecentric.mule.assertobjectequals.AssertObjectEqualsConnector#compareObjects(java.lang.Object, java.lang.String, boolean, boolean, java.util.List, org.mule.api.MuleEvent)} method in {@link AssertObjectEqualsConnector }. For each argument there is a field in this processor to match it.  Before invoking the actual method the processor will evaluate and transform where possible to the expected argument type.
 * 
 */
@SuppressWarnings("all")
@Generated(value = "Mule DevKit Version 3.9.7", date = "2019-02-27T07:16:01+01:00", comments = "Build mule-devkit-3.9.7.2818.62a60e1")
public class CompareObjectsMessageProcessor
    extends DevkitBasedMessageProcessor
    implements MessageProcessor, OperationMetaDataEnabled
{

    protected Object expected;
    protected Object _expectedType;
    protected Object actualExpression;
    protected String _actualExpressionType;
    protected Object containsOnlyOnMaps;
    protected boolean _containsOnlyOnMapsType;
    protected Object checkMapOrder;
    protected boolean _checkMapOrderType;
    protected Object pathOptions;
    protected List<String> _pathOptionsType;
    protected Object event;
    protected MuleEvent _eventType;

    public CompareObjectsMessageProcessor(String operationName) {
        super(operationName);
    }

    /**
     * Obtains the expression manager from the Mule context and initialises the connector. If a target object  has not been set already it will search the Mule registry for a default one.
     * 
     * @throws InitialisationException
     */
    public void initialise()
        throws InitialisationException
    {
    }

    @Override
    public void start()
        throws MuleException
    {
        super.start();
    }

    @Override
    public void stop()
        throws MuleException
    {
        super.stop();
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    /**
     * Sets pathOptions
     * 
     * @param value Value to set
     */
    public void setPathOptions(Object value) {
        this.pathOptions = value;
    }

    /**
     * Sets containsOnlyOnMaps
     * 
     * @param value Value to set
     */
    public void setContainsOnlyOnMaps(Object value) {
        this.containsOnlyOnMaps = value;
    }

    /**
     * Sets expected
     * 
     * @param value Value to set
     */
    public void setExpected(Object value) {
        this.expected = value;
    }

    /**
     * Sets checkMapOrder
     * 
     * @param value Value to set
     */
    public void setCheckMapOrder(Object value) {
        this.checkMapOrder = value;
    }

    /**
     * Sets event
     * 
     * @param value Value to set
     */
    public void setEvent(Object value) {
        this.event = value;
    }

    /**
     * Sets actualExpression
     * 
     * @param value Value to set
     */
    public void setActualExpression(Object value) {
        this.actualExpression = value;
    }

    /**
     * Invokes the MessageProcessor.
     * 
     * @param event MuleEvent to be processed
     * @throws Exception
     */
    public MuleEvent doProcess(final MuleEvent event)
        throws Exception
    {
        Object moduleObject = null;
        try {
            moduleObject = findOrCreate(AssertObjectEqualsConnectorProcessAdapter.class, true, event);
            final Object _transformedExpected = ((Object) evaluateAndTransform(getMuleContext(), event, CompareObjectsMessageProcessor.class.getDeclaredField("_expectedType").getGenericType(), null, expected));
            final String _not_evaluatedActualExpression = ((String) this.actualExpression);
            final Boolean _transformedContainsOnlyOnMaps = ((Boolean) evaluateAndTransform(getMuleContext(), event, CompareObjectsMessageProcessor.class.getDeclaredField("_containsOnlyOnMapsType").getGenericType(), null, containsOnlyOnMaps));
            final Boolean _transformedCheckMapOrder = ((Boolean) evaluateAndTransform(getMuleContext(), event, CompareObjectsMessageProcessor.class.getDeclaredField("_checkMapOrderType").getGenericType(), null, checkMapOrder));
            final List<String> _transformedPathOptions = ((List<String> ) evaluateAndTransform(getMuleContext(), event, CompareObjectsMessageProcessor.class.getDeclaredField("_pathOptionsType").getGenericType(), null, pathOptions));
            Object resultPayload;
            final ProcessTemplate<Object, Object> processTemplate = ((ProcessAdapter<Object> ) moduleObject).getProcessTemplate();
            resultPayload = processTemplate.execute(new ProcessCallback<Object,Object>() {


                public List<Class<? extends Exception>> getManagedExceptions() {
                    return null;
                }

                public boolean isProtected() {
                    return false;
                }

                public Object process(Object object)
                    throws Exception
                {
                    return ((AssertObjectEqualsConnector) object).compareObjects(_transformedExpected, _not_evaluatedActualExpression, _transformedContainsOnlyOnMaps, _transformedCheckMapOrder, _transformedPathOptions, event);
                }

            }
            , this, event);
            ((DefaultMuleMessage) event.getMessage()).setPayload(((TransformingValue) resultPayload).getValue());
            ((DefaultMuleMessage) event.getMessage()).setMimeType(((TransformingValue) resultPayload).getDataType().getMimeType());
            ((DefaultMuleMessage) event.getMessage()).setEncoding(((TransformingValue) resultPayload).getDataType().getEncoding());
            return event;
        } catch (Exception e) {
            throw e;
        }
    }

    @Override
    public Result<MetaData> getInputMetaData() {
        MetaDataModel metaDataPayload = getPojoOrSimpleModel(String.class);
        DefaultMetaDataKey keyForStudio = new DefaultMetaDataKey("INPUT_METADATA", null);
        metaDataPayload.addProperty(STUDIO7157 .getStructureIdentifierMetaDataModelProperty(keyForStudio, false, false));
        return new DefaultResult<MetaData>(new DefaultMetaData(metaDataPayload));
    }

    @Override
    public Result<MetaData> getOutputMetaData(MetaData inputMetadata) {
        MetaDataModel metaDataPayload = getPojoOrSimpleModel(Object.class);
        DefaultMetaDataKey keyForStudio = new DefaultMetaDataKey("OUTPUT_METADATA", null);
        metaDataPayload.addProperty(STUDIO7157 .getStructureIdentifierMetaDataModelProperty(keyForStudio, false, false));
        return new DefaultResult<MetaData>(new DefaultMetaData(metaDataPayload));
    }

    private MetaDataModel getPojoOrSimpleModel(Class clazz) {
        DataType dataType = DataTypeFactory.getInstance().getDataType(clazz);
        if (DataType.POJO.equals(dataType)) {
            return new DefaultPojoMetaDataModel(clazz);
        } else {
            return new DefaultSimpleMetaDataModel(dataType);
        }
    }

    public Result<MetaData> getGenericMetaData(MetaDataKey metaDataKey) {
        ConnectorMetaDataEnabled connector;
        try {
            connector = ((ConnectorMetaDataEnabled) findOrCreate(null, false, null));
            try {
                Result<MetaData> metadata = connector.getMetaData(metaDataKey);
                if ((Result.Status.FAILURE).equals(metadata.getStatus())) {
                    return metadata;
                }
                if (metadata.get() == null) {
                    return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), "There was an error processing metadata at AssertObjectEqualsConnector at compareObjects retrieving was successful but result is null");
                }
                return metadata;
            } catch (Exception e) {
                return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
            }
        } catch (ClassCastException cast) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), "There was an error getting metadata, there was no connection manager available. Maybe you're trying to use metadata from an Oauth connector");
        } catch (ConfigurationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (RegistrationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (IllegalAccessException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (InstantiationException e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        } catch (Exception e) {
            return new DefaultResult<MetaData>(null, (Result.Status.FAILURE), e.getMessage(), FailureType.UNSPECIFIED, e);
        }
    }

}
