/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.modules.assertobjectequals.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.codecentric.mule.modules.assertobjectequals.internal.ObjectComparator;
import de.codecentric.mule.modules.assertobjectequals.internal.PathOption;
import de.codecentric.mule.modules.assertobjectequals.internal.PathPattern;
import de.codecentric.mule.modules.assertobjectequals.internal.PathPatternParser;
import de.codecentric.mule.modules.assertobjectequals.internal.PatternBasedOptionsFactory;
import de.codecentric.mule.modules.assertobjectequals.internal.XmlCompareOption;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.diff.ComparisonFormatter;
import org.xmlunit.diff.DefaultComparisonFormatter;
import org.xmlunit.diff.Diff;

public class Operations {
    public void compareObjects(@DisplayName(value="Expected value") @Example(value="#[MunitTools::getResourceAsStream()]") Object expected, @DisplayName(value="Actual value") @Example(value="#[payload]") Object actual, @DisplayName(value="Contains only on maps") @Optional(defaultValue="false") boolean containsOnlyOnMaps, @DisplayName(value="Check map order") @Optional(defaultValue="false") boolean checkMapOrder, @DisplayName(value="Path patterns+options") List<String> pathOptions) throws Exception {
        Object expectedObj = this.convert2Object(expected);
        Object actualObj = this.convert2Object(actual);
        ObjectComparator comparator = this.createComparator(containsOnlyOnMaps, checkMapOrder, pathOptions == null ? new ArrayList() : pathOptions);
        Collection<String> diff = comparator.compare(expectedObj, actualObj);
        if (!diff.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (String s : diff) {
                if (messageBuilder.length() > 0) {
                    messageBuilder.append(System.lineSeparator());
                }
                messageBuilder.append(s);
            }
            throw new AssertionError(messageBuilder);
        }
    }

    public void compareXml(@DisplayName(value="Expected value") @Example(value="#[MunitTools::getResourceAsStream()]") Object expected, @DisplayName(value="Actual value") @Example(value="#[payload]") Object actual, @DisplayName(value="XML compare option") @OfValues(value=XmlCompareOption.class) String xmlCompareOption) throws Exception {
        DiffBuilder diffBuilder = DiffBuilder.compare((Object)expected).withTest(actual);
        switch (xmlCompareOption) {
            case "IGNORE_COMMENTS": {
                diffBuilder = diffBuilder.ignoreComments();
                break;
            }
            case "IGNORE_WHITESPACE": {
                diffBuilder = diffBuilder.ignoreWhitespace();
                break;
            }
            case "NORMALIZE_WHITESPACE": {
                diffBuilder = diffBuilder.normalizeWhitespace();
                break;
            }
            default: {
                throw new IllegalArgumentException("I forgot to implement for a new enum constant.");
            }
        }
        Diff diff = diffBuilder.build();
        if (diff.hasDifferences()) {
            throw new AssertionError((Object)diff.toString((ComparisonFormatter)new DefaultComparisonFormatter()));
        }
    }

    private Object convert2Object(Object value) throws JsonProcessingException, IOException {
        if (value == null) {
            return null;
        }
        if (value instanceof InputStream) {
            return new ObjectMapper().readerFor(Object.class).readValue((InputStream)value);
        }
        if (value instanceof byte[]) {
            return new ObjectMapper().readerFor(Object.class).readValue((byte[])value);
        }
        if (value instanceof CharSequence) {
            String trimmed = ((CharSequence)value).toString().trim();
            if (trimmed.startsWith("[") || trimmed.startsWith("{")) {
                return new ObjectMapper().readerFor(Object.class).readValue(trimmed);
            }
            return value;
        }
        return value;
    }

    private ObjectComparator createComparator(boolean containsOnlyOnMaps, boolean checkMapOrder, List<String> pathOptionsStrings) {
        PathPatternParser ppp = new PathPatternParser();
        ArrayList<PathPattern> patterns = new ArrayList<PathPattern>();
        for (String pathOptionString : pathOptionsStrings) {
            patterns.add(ppp.parse(pathOptionString));
        }
        EnumSet<PathOption> rootOptions = EnumSet.noneOf(PathOption.class);
        if (containsOnlyOnMaps) {
            rootOptions.add(PathOption.CONTAINS_ONLY_ON_MAPS);
        }
        if (checkMapOrder) {
            rootOptions.add(PathOption.CHECK_MAP_ORDER);
        }
        PatternBasedOptionsFactory optionFactory = new PatternBasedOptionsFactory(rootOptions, patterns);
        return new ObjectComparator(optionFactory);
    }
}

