/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.modules.assertobjectequals.internal;

public class Path {
    private Path predecessor;
    private String key;
    private int index;
    private int listSize;

    public Path() {
    }

    private Path(Path predecessor) {
        this.predecessor = predecessor;
    }

    private Path(String key, Path predecessor) {
        this(predecessor);
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.key = key;
    }

    private Path(int listIndex, int listSize, Path predecessor) {
        this(predecessor);
        if (listSize < 0) {
            throw new IllegalArgumentException();
        }
        if (listIndex < 0 || listIndex >= listSize) {
            throw new IllegalArgumentException("Illegal index: " + listIndex);
        }
        this.index = listIndex;
        this.listSize = listSize;
    }

    public Path listEntry(int listIndex, int listSize) {
        return new Path(listIndex, listSize, this);
    }

    public Path mapEntry(String key) {
        return new Path(key, this);
    }

    public boolean isRoot() {
        return this.predecessor == null;
    }

    public boolean isList() {
        return !this.isRoot() && this.key == null;
    }

    public boolean isMap() {
        return !this.isRoot() && this.key != null;
    }

    public Path getPredecessor() {
        if (this.isRoot()) {
            throw new IllegalStateException("root has no predecessor");
        }
        return this.predecessor;
    }

    public String getKey() {
        return this.key;
    }

    public int getIndex() {
        return this.index;
    }

    public int getListSize() {
        return this.listSize;
    }

    public String toString() {
        String result = this.isRoot() ? "" : this.predecessor.toString() + this.meToString();
        return result;
    }

    private String meToString() {
        if (this.key != null) {
            return "['" + this.key + "']";
        }
        return "[" + this.index + "]";
    }
}

