/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.modules.assertobjectequals.internal;

import de.codecentric.mule.modules.assertobjectequals.internal.PathOption;
import de.codecentric.mule.modules.assertobjectequals.internal.PathPattern;
import de.codecentric.mule.modules.assertobjectequals.internal.PatternEntry;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PathPatternParser {
    public PathPattern parse(String input) {
        State state = new State(input);
        PatternEntry[] entries = this.parseEntries(state);
        EnumSet<PathOption> options = this.parseOptions(state);
        return new PathPattern(entries, options);
    }

    private PatternEntry[] parseEntries(State state) {
        ArrayList<PatternEntry> entries = new ArrayList<PatternEntry>();
        this.skipWhitespace(state);
        block5: while (!state.eof() && this.isPathStartCharacter(state.peek())) {
            switch (state.peek()) {
                case '?': {
                    entries.add(PatternEntry.createWildcardOne());
                    state.next();
                    continue block5;
                }
                case '*': {
                    entries.add(PatternEntry.createWildcardAny());
                    state.next();
                    continue block5;
                }
                case '[': {
                    state.next();
                    entries.add(this.listOrMap(state));
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown character '" + state.peek() + "' at position " + state.getPosition());
        }
        return entries.toArray(new PatternEntry[entries.size()]);
    }

    private boolean isPathStartCharacter(char ch) {
        return ch == '?' || ch == '*' || ch == '[';
    }

    private PatternEntry listOrMap(State state) {
        if (state.peek() == '\'') {
            return this.map(state);
        }
        return this.list(state);
    }

    private PatternEntry map(State state) {
        state.nextExpected('\'');
        StringBuilder sb = new StringBuilder();
        while (state.peek() != '\'' || state.peek(1) != ']') {
            if (state.peek() == '\'') {
                state.next();
                if (state.peek() == '\'') {
                    sb.append(state.next());
                    continue;
                }
                throw new IllegalArgumentException("' must be followed by ' or ], not '" + state.peek() + "' at position " + state.getPosition());
            }
            sb.append(state.next());
        }
        state.nextExpected('\'');
        state.nextExpected(']');
        return PatternEntry.createMap(Pattern.compile(sb.toString()));
    }

    private PatternEntry list(State state) {
        if (state.peek() == '#') {
            state.next();
            state.nextExpected(']');
            return PatternEntry.createList(null);
        }
        StringBuilder sb = new StringBuilder();
        if (state.peek() == '-') {
            sb.append(state.next());
        }
        while (state.peek() != ']') {
            sb.append(state.next());
        }
        state.next();
        int index = Integer.parseInt(sb.toString());
        return PatternEntry.createList(index);
    }

    private EnumSet<PathOption> parseOptions(State state) {
        EnumSet<PathOption> options = EnumSet.noneOf(PathOption.class);
        while (!state.eof()) {
            String word = this.readNextWord(state);
            if (StringUtils.isEmpty((CharSequence)word)) {
                if (state.eof()) continue;
                throw new IllegalArgumentException("'" + state.peek() + "' is not valid as start of option.");
            }
            options.add(this.stringToOption(word));
        }
        return options;
    }

    private PathOption stringToOption(String word) {
        try {
            return Enum.valueOf(PathOption.class, word.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder();
            sb.append("Illegal path option \"").append(word).append("\", valid options are: ");
            for (PathOption option : PathOption.values()) {
                sb.append(option.toString()).append(", ");
            }
            String message = sb.substring(0, sb.length() - 2);
            throw new IllegalArgumentException(message);
        }
    }

    private String readNextWord(State state) {
        this.skipWhitespace(state);
        StringBuilder sb = new StringBuilder();
        while (!state.eof() && (Character.isLetterOrDigit(state.peek()) || state.peek() == '_')) {
            sb.append(state.next());
        }
        return sb.toString();
    }

    private void skipWhitespace(State state) {
        while (!state.eof() && Character.isWhitespace(state.peek())) {
            state.next();
        }
    }

    static class State {
        final String input;
        int position;

        State(String input) {
            this.input = input;
        }

        boolean eof() {
            return this.position == this.input.length();
        }

        char peek() {
            this.assertNotEof();
            return this.input.charAt(this.position);
        }

        char peek(int delta) {
            return this.input.charAt(this.position + delta);
        }

        char next() {
            this.assertNotEof();
            return this.input.charAt(this.position++);
        }

        void nextExpected(char c) {
            if (c != this.peek()) {
                throw new IllegalArgumentException("Expect '" + c + "' at position " + this.position + " but found '" + this.peek() + "'");
            }
            this.next();
        }

        private void assertNotEof() {
            if (this.eof()) {
                throw new IllegalArgumentException("unexpected end of path pattern");
            }
        }

        int getPosition() {
            return this.position;
        }

        public String toString() {
            if (this.eof()) {
                return "EOF";
            }
            StringBuilder sb = new StringBuilder(2 * this.input.length() + 3);
            sb.append(this.input).append(System.lineSeparator());
            for (int i = 0; i < this.position; ++i) {
                sb.append(' ');
            }
            sb.append('^');
            return sb.toString();
        }
    }
}

