/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.modules.assertobjectequals.internal;

import java.util.regex.Pattern;

public class PatternEntry {
    private final PatternEntryType type;
    private Pattern keyPattern;
    private Integer listIndex;

    private PatternEntry(PatternEntryType type) {
        this.type = type;
    }

    public static PatternEntry createMap(Pattern keyPattern) {
        PatternEntry pe = new PatternEntry(PatternEntryType.MAP);
        pe.keyPattern = keyPattern == null ? Pattern.compile(".*") : keyPattern;
        return pe;
    }

    public static PatternEntry createList(Integer listIndex) {
        PatternEntry pe = new PatternEntry(PatternEntryType.LIST);
        pe.listIndex = listIndex;
        return pe;
    }

    public static PatternEntry createWildcardAny() {
        PatternEntry pe = new PatternEntry(PatternEntryType.WILDCARD_ANY);
        return pe;
    }

    public static PatternEntry createWildcardOne() {
        PatternEntry pe = new PatternEntry(PatternEntryType.WILDCARD_ONE);
        return pe;
    }

    public PatternEntryType getType() {
        return this.type;
    }

    public Pattern getKeyPattern() {
        if (this.type != PatternEntryType.MAP) {
            throw new IllegalStateException("type is " + (Object)((Object)this.type));
        }
        return this.keyPattern;
    }

    public Integer getListIndex() {
        if (this.type != PatternEntryType.LIST) {
            throw new IllegalStateException("type is " + (Object)((Object)this.type));
        }
        return this.listIndex;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        switch (this.type) {
            case LIST: {
                sb.append('[');
                if (this.listIndex == null) {
                    sb.append('#');
                } else {
                    sb.append(Integer.toString(this.listIndex));
                }
                sb.append(']');
                break;
            }
            case MAP: {
                sb.append("['");
                for (char ch : this.keyPattern.toString().toCharArray()) {
                    if (ch == '\'') {
                        sb.append("''");
                        continue;
                    }
                    sb.append(ch);
                }
                sb.append("']");
                break;
            }
            case WILDCARD_ANY: {
                sb.append('*');
                break;
            }
            case WILDCARD_ONE: {
                sb.append('?');
            }
        }
        return sb.toString();
    }

    static enum PatternEntryType {
        MAP,
        LIST,
        WILDCARD_ONE,
        WILDCARD_ANY;

    }
}

