/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.loop.api;

import de.codecentric.mule.loop.api.LoopError;
import de.codecentric.mule.loop.api.OperationErrorTypeProvider;
import de.codecentric.mule.loop.api.PayloadAfterLoop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.sdk.api.annotation.param.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoopOperations {
    private static Logger logger = LoggerFactory.getLogger(LoopOperations.class);
    @Inject
    private ExpressionManager expressionManager;

    @MediaType(value="*/*")
    public void repeatUntilPayloadNotEmpty(Chain operations, CompletionCallback<Object, Object> callback) throws InterruptedException {
        boolean continueLoop;
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        do {
            operations.process(result -> {
                if (this.isEmpty(result.getOutput())) {
                    queue.offer(Boolean.TRUE);
                } else {
                    queue.offer(Boolean.FALSE);
                    callback.success(result);
                }
            }, (error, previous) -> {
                callback.error(error);
                queue.offer(Boolean.FALSE);
            });
        } while (continueLoop = ((Boolean)queue.take()).booleanValue());
    }

    private boolean isEmpty(Object output) {
        boolean result;
        if (output == null) {
            logger.debug("output is null");
            result = true;
        } else if (output instanceof String) {
            result = ((String)output).trim().isEmpty();
        } else if (output instanceof Collection) {
            result = ((Collection)output).isEmpty();
        } else if (output instanceof Map) {
            result = ((Map)output).isEmpty();
        } else {
            TypedValue expressionResult;
            BindingContext context;
            if (logger.isDebugEnabled()) {
                logger.debug("try with DataWeave isEmpty()");
                context = BindingContext.builder().addBinding("value", TypedValue.of((Object)output)).build();
                expressionResult = this.expressionManager.evaluate("value as String", context);
                logger.debug("evaluate isEmpty({})", expressionResult.getValue());
            }
            context = BindingContext.builder().addBinding("value", TypedValue.of((Object)output)).build();
            expressionResult = this.expressionManager.evaluate("isEmpty(value)", context);
            result = (Boolean)expressionResult.getValue();
        }
        logger.debug("isEmpty(...): {}", (Object)result);
        return result;
    }

    @Alias(value="while")
    @MediaType(value="*/*")
    @Throws(value={OperationErrorTypeProvider.class})
    public void whileLoop(Chain operations, CompletionCallback<Object, Object> callback, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean condition, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Object initialPayload, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="PAYLOAD_OF_LAST_ITERATION") PayloadAfterLoop resultPayload) throws InterruptedException {
        if (resultPayload == PayloadAfterLoop.ITERATOR_OF_ALL_PAYLOADS_WITHIN) {
            this.whileLoopStreaming(operations, callback, condition, initialPayload);
        } else {
            this.whileLoopInMemory(operations, callback, condition, initialPayload, resultPayload);
        }
    }

    private void whileLoopInMemory(Chain operations, CompletionCallback<Object, Object> callback, boolean condition, Object initialPayload, PayloadAfterLoop resultPayload) throws InterruptedException {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        ArrayList<Object> resultCollection = resultPayload == PayloadAfterLoop.COLLECTION_OF_ALL_PAYLOADS_WITHIN ? new ArrayList<Object>() : null;
        boolean firstIteration = true;
        WhileQueueEntry entry = new WhileQueueEntry(condition, initialPayload, null);
        while (entry.condition) {
            Object nextPayload = firstIteration ? initialPayload : entry.payload;
            operations.process(nextPayload, (Object)Collections.EMPTY_MAP, result -> {
                Map<String, Object> payload = this.payloadAsMap((Result<?, ?>)result);
                queue.offer(new WhileQueueEntry(this.evaluateCondition(payload.get("condition")), payload.get("nextPayload"), payload.get("addToCollection")));
            }, (error, previous) -> {
                callback.error(error);
                queue.offer(new WhileQueueEntry((Throwable)error));
            });
            entry = (WhileQueueEntry)queue.take();
            if (resultPayload == PayloadAfterLoop.COLLECTION_OF_ALL_PAYLOADS_WITHIN) {
                resultCollection.add(entry.addToCollection);
            }
            firstIteration = false;
        }
        if (entry.error == null) {
            if (resultPayload == PayloadAfterLoop.COLLECTION_OF_ALL_PAYLOADS_WITHIN) {
                callback.success(Result.builder().output(resultCollection).build());
            } else if (resultPayload == PayloadAfterLoop.PAYLOAD_BEFORE_LOOP) {
                callback.success(Result.builder().output(initialPayload).build());
            } else {
                callback.success(Result.builder().output(entry.payload).build());
            }
        }
    }

    private void whileLoopStreaming(final Chain operations, CompletionCallback<Object, Object> callback, final boolean condition, final Object initialPayload) throws InterruptedException {
        Iterator<Object> result = new Iterator<Object>(){
            boolean firstIteration = true;
            WhileQueueEntry entry = new WhileQueueEntry(condition, initialPayload, null);

            @Override
            public boolean hasNext() {
                return this.entry.condition;
            }

            @Override
            public Object next() {
                Object nextPayload = this.firstIteration ? initialPayload : this.entry.payload;
                ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
                operations.process(nextPayload, (Object)Collections.EMPTY_MAP, result -> {
                    Map payload = LoopOperations.this.payloadAsMap(result);
                    queue.offer(new WhileQueueEntry(LoopOperations.this.evaluateCondition(payload.get("condition")), payload.get("nextPayload"), payload.get("addToCollection")));
                }, (error, previous) -> queue.offer(new WhileQueueEntry((Throwable)error)));
                try {
                    this.firstIteration = false;
                    this.entry = (WhileQueueEntry)queue.take();
                    if (this.entry.error != null) {
                        throw new RuntimeException(this.entry.error);
                    }
                    return this.entry.addToCollection;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        callback.success(Result.builder().output((Object)result).build());
    }

    private Map<String, Object> payloadAsMap(Result<?, ?> result) {
        Object rawPayload = result.getOutput();
        if (!(rawPayload instanceof Map)) {
            throw new ModuleException("Payload should be Map, but is: " + (rawPayload == null ? "null" : rawPayload.getClass()), (ErrorTypeDefinition)LoopError.PAYLOAD_IS_NOT_MAP);
        }
        return (Map)rawPayload;
    }

    boolean evaluateCondition(Object condition) {
        if (condition == null) {
            return false;
        }
        if (condition instanceof Boolean) {
            return (Boolean)condition;
        }
        return !this.isEmpty(condition);
    }

    @Alias(value="for")
    @MediaType(value="*/*")
    public void forLoop(Chain operations, CompletionCallback<Object, Object> callback, @DisplayName(value="start (inclusive)") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="0") int start, @DisplayName(value="end (exclusive)") int end, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean counterAsPayload) throws InterruptedException {
        if (start < end) {
            if (counterAsPayload) {
                this.forWithCounter(operations, callback, start, end);
            } else {
                this.forWithPayload(operations, callback, start, end);
            }
        } else {
            callback.success(Result.builder().build());
        }
    }

    private void forWithCounter(Chain operations, CompletionCallback<Object, Object> callback, int start, int end) throws InterruptedException {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        boolean continueLoop = true;
        int i = start;
        while (i < end && continueLoop) {
            int counter = i++;
            operations.process((Object)counter, (Object)Collections.EMPTY_MAP, result -> {
                if (counter + 1 == end) {
                    callback.success(result);
                }
                queue.offer(Boolean.TRUE);
            }, (error, previous) -> {
                callback.error(error);
                queue.offer(Boolean.FALSE);
            });
            continueLoop = (Boolean)queue.take();
        }
    }

    private void forWithPayload(Chain operations, CompletionCallback<Object, Object> callback, int start, int end) throws InterruptedException {
        AtomicBoolean continueLoop = new AtomicBoolean(true);
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        Object payload = null;
        for (int i = start; i < end && continueLoop.get(); ++i) {
            int counter = i;
            if (counter == start) {
                operations.process(result -> {
                    if (counter + 1 == end) {
                        callback.success(result);
                    }
                    queue.offer(Optional.ofNullable(result.getOutput()));
                }, (error, previous) -> {
                    callback.error(error);
                    continueLoop.set(false);
                    queue.offer(Optional.empty());
                });
            } else {
                operations.process(payload, (Object)Collections.EMPTY_MAP, result -> {
                    if (counter + 1 == end) {
                        callback.success(result);
                    }
                    queue.offer(Optional.ofNullable(result.getOutput()));
                }, (error, previous) -> {
                    callback.error(error);
                    continueLoop.set(false);
                    queue.offer(Optional.empty());
                });
            }
            payload = ((Optional)queue.take()).orElse(null);
        }
    }

    @Alias(value="for-each")
    @MediaType(value="*/*")
    public void forEachLoop(Chain operations, CompletionCallback<Object, Object> callback, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Object values, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean streaming) throws InterruptedException {
        Iterator valueIterator;
        if (values instanceof Collection) {
            valueIterator = ((Collection)values).iterator();
        } else if (values instanceof Iterator) {
            valueIterator = (Iterator)values;
        } else {
            String type = values == null ? "<null>" : values.getClass().getName();
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Can't loop over " + type + ", only Collection or Iterator are valid options")));
        }
        if (streaming) {
            this.forEachLoopStreaming(operations, callback, valueIterator);
        } else {
            this.forEachLoopInMemory(operations, callback, valueIterator);
        }
    }

    private void forEachLoopInMemory(Chain operations, CompletionCallback<Object, Object> callback, Iterator<Object> values) throws InterruptedException {
        AtomicBoolean errorOccured = new AtomicBoolean(false);
        ArrayList<Object> resultCollection = new ArrayList<Object>();
        ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
        while (values.hasNext()) {
            Object value = values.next();
            if (errorOccured.get()) break;
            operations.process(value, (Object)Collections.EMPTY_MAP, result -> queue.offer(Optional.ofNullable(result.getOutput())), (error, previous) -> {
                callback.error(error);
                errorOccured.set(true);
                queue.offer(Optional.empty());
            });
            resultCollection.add(((Optional)queue.take()).orElse(null));
        }
        if (!errorOccured.get()) {
            callback.success(Result.builder().output(resultCollection).build());
        }
    }

    private void forEachLoopStreaming(final Chain operations, CompletionCallback<Object, Object> callback, final Iterator<Object> values) {
        Iterator<Object> result = new Iterator<Object>(){

            @Override
            public boolean hasNext() {
                return values.hasNext();
            }

            @Override
            public Object next() {
                Object value = values.next();
                ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
                operations.process(value, (Object)Collections.EMPTY_MAP, result -> queue.offer(new ForQueueEntry(result.getOutput())), (error, previous) -> queue.offer(new ForQueueEntry((Throwable)error)));
                try {
                    ForQueueEntry entry = (ForQueueEntry)queue.take();
                    if (entry.error == null) {
                        return entry.value;
                    }
                    throw new RuntimeException(entry.error);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        callback.success(Result.builder().output((Object)result).build());
    }

    private static class ForQueueEntry {
        private final Object value;
        private final Throwable error;

        public ForQueueEntry(Object value) {
            this.value = value;
            this.error = null;
        }

        public ForQueueEntry(Throwable error) {
            this.value = null;
            this.error = error;
        }
    }

    private static class WhileQueueEntry {
        private final boolean condition;
        private final Throwable error;
        private final Object payload;
        private final Object addToCollection;

        public WhileQueueEntry(boolean condition, Object payload, Object addToCollection) {
            this.condition = condition;
            this.error = null;
            this.payload = payload;
            this.addToCollection = addToCollection;
        }

        public WhileQueueEntry(Throwable error) {
            this.condition = false;
            this.error = error;
            this.payload = null;
            this.addToCollection = null;
        }
    }
}

