/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.limiter.internal;

import de.codecentric.limiter.internal.RatelimiterOperations;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.param.Parameter;

@Configuration(name="rate-limiter")
@Operations(value={RatelimiterOperations.class})
public class RatelimiterConfiguration {
    @Parameter
    private long minTimeBetweenOperations;
    @Parameter
    private TimeUnit unit;
    private static final long NEVER = -1L;
    private LinkedList<Runnable> commandList = new LinkedList();
    private long lastRun = -1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(ScheduledExecutorService scheduledExecutor, Runnable command) {
        long minTimeBetweenOperationsInMillis = this.unit.toMillis(this.minTimeBetweenOperations);
        LinkedList<Runnable> linkedList = this.commandList;
        synchronized (linkedList) {
            boolean listWasEmpty = this.commandList.isEmpty();
            this.commandList.add(command);
            if (listWasEmpty) {
                long now = System.currentTimeMillis();
                if (this.lastRun == -1L || now >= this.lastRun + minTimeBetweenOperationsInMillis) {
                    scheduledExecutor.schedule(new Runner(scheduledExecutor), 0L, TimeUnit.MILLISECONDS);
                } else {
                    scheduledExecutor.schedule(new Runner(scheduledExecutor), this.lastRun + minTimeBetweenOperationsInMillis - now, TimeUnit.MILLISECONDS);
                }
            }
        }
    }

    private class Runner
    implements Runnable {
        ScheduledExecutorService scheduledExecutor;

        public Runner(ScheduledExecutorService scheduledExecutor) {
            this.scheduledExecutor = scheduledExecutor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable command;
            RatelimiterConfiguration.this.lastRun = System.currentTimeMillis();
            long minTimeBetweenOperationsInMillis = RatelimiterConfiguration.this.unit.toMillis(RatelimiterConfiguration.this.minTimeBetweenOperations);
            LinkedList linkedList = RatelimiterConfiguration.this.commandList;
            synchronized (linkedList) {
                command = (Runnable)RatelimiterConfiguration.this.commandList.peek();
            }
            try {
                command.run();
            }
            finally {
                linkedList = RatelimiterConfiguration.this.commandList;
                synchronized (linkedList) {
                    RatelimiterConfiguration.this.commandList.remove();
                    if (!RatelimiterConfiguration.this.commandList.isEmpty()) {
                        this.scheduledExecutor.schedule(this, minTimeBetweenOperationsInMillis, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }
    }
}

