/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.limiter.api;

import de.codecentric.limiter.api.RateLimiterError;
import de.codecentric.limiter.api.RatelimiterConfiguration;
import de.codecentric.limiter.api.SetAttributesOutputResolver;
import de.codecentric.limiter.internal.BufferErrorProvider;
import de.codecentric.limiter.internal.Handle429ErrorProvider;
import de.codecentric.limiter.internal.WaitTimeStorage;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RatelimiterOperations
implements Startable,
Stoppable {
    private static Logger logger = LoggerFactory.getLogger(RatelimiterOperations.class);
    @Inject
    private SchedulerService schedulerService;
    private ScheduledExecutorService scheduledExecutor;
    @Inject
    private ExpressionManager expressionManager;
    private static WaitTimeStorage waitTimes = new WaitTimeStorage();

    public void start() {
        SchedulerConfig config = SchedulerConfig.config().withMaxConcurrentTasks(2).withShutdownTimeout(1L, TimeUnit.SECONDS).withPrefix("rate-limit").withName("operations");
        this.scheduledExecutor = this.schedulerService.customScheduler(config);
    }

    public void stop() {
        this.scheduledExecutor.shutdown();
    }

    @Throws(value={BufferErrorProvider.class})
    public void limitRate(@Config RatelimiterConfiguration configuration, CompletionCallback<Void, Void> callback) {
        logger.debug("schedule command");
        configuration.schedule(this.scheduledExecutor, () -> {
            logger.debug("execute command");
            callback.success(Result.builder().build());
        });
    }

    public void fixedDelay(long delay, TimeUnit unit, CompletionCallback<Void, Void> callback) {
        logger.debug("delay: " + delay + ", unit: " + (Object)((Object)unit));
        this.scheduledExecutor.schedule(() -> {
            logger.debug("execute delayed command");
            callback.success(Result.builder().build());
        }, delay, unit);
    }

    @OutputResolver(output=SetAttributesOutputResolver.class)
    public Result<Object, Object> setAttributes(@org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[payload]") Object payload, @Expression(value=ExpressionSupport.REQUIRED) Object attributes) {
        return Result.builder().output(payload).attributes(attributes).build();
    }

    @Alias(value="handle-429")
    @Throws(value={Handle429ErrorProvider.class})
    @MediaType(value="*/*")
    public void handleRetryAfter(Chain operations, CompletionCallback<Object, Object> callback, @Summary(value="Resource ID") String id, @Summary(value="How often shall the operation be retried when the first try failed?") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="5") int numberOfRetries, @Summary(value="Status code for wait") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="429") int waitStatusCode, @Summary(value="A DataWeave expression to compute the time to wait (in milliseconds).The following values are available: headers: The HTTP response headers as mapretryIndex: Which retry attemt is this (first retry: 1). ") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[(headers.\"retry-after\" default \"0\" as Number + random() * 100) * 1000]") Literal<String> waitTimeExpression, @Summary(value="Additional wait time when joining an already active wait (in milliseconds).") @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="#[100 + random() * 1000]") Literal<String> joinWaitTimeExpression) {
        RetryAfterRunner repeatRunner = new RetryAfterRunner(operations, callback, id, numberOfRetries, waitStatusCode, (String)waitTimeExpression.getLiteralValue().get(), (String)joinWaitTimeExpression.getLiteralValue().get());
        repeatRunner.run();
    }

    public class RetryAfterRunner
    implements Runnable {
        private Chain operations;
        private CompletionCallback<Object, Object> callback;
        private String id;
        private int numberOfRetries;
        private int waitStatusCode;
        private String waitTimeExpression;
        private String joinWaitTimeExpression;
        private int retryIndex;

        private RetryAfterRunner(Chain operations, CompletionCallback<Object, Object> callback, String id, int numberOfRetries, int waitStatusCode, String waitTimeExpression, String joinWaitTimeExpression) {
            this.operations = operations;
            this.callback = callback;
            this.id = id;
            this.numberOfRetries = numberOfRetries;
            this.waitStatusCode = waitStatusCode;
            this.waitTimeExpression = waitTimeExpression;
            this.joinWaitTimeExpression = joinWaitTimeExpression;
        }

        @Override
        public void run() {
            Optional<Long> waitUntil = waitTimes.retrieveWaitTime(this.id);
            if (waitUntil.isPresent()) {
                long delay = Math.max(0L, waitUntil.get() - System.currentTimeMillis());
                logger.info("enter running delay: {}", (Object)(delay += this.computeAdditionalJoinDelay()));
                RatelimiterOperations.this.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else {
                logger.debug("run, retryIndex: {}", (Object)this.retryIndex);
                this.operations.process(result -> {
                    block5: {
                        if (result.getAttributes().isPresent()) {
                            Object attributes = result.getAttributes().get();
                            Class<?> clazz = attributes.getClass();
                            try {
                                int statusCode = (Integer)clazz.getMethod("getStatusCode", new Class[0]).invoke(attributes, new Object[0]);
                                logger.debug("status code: {}", (Object)statusCode);
                                if (statusCode == this.waitStatusCode) {
                                    Map headers = (Map)clazz.getMethod("getHeaders", new Class[0]).invoke(attributes, new Object[0]);
                                    this.delayExecution(headers);
                                    break block5;
                                }
                                this.callback.success(result);
                            }
                            catch (ReflectiveOperationException | SecurityException e) {
                                this.callback.error((Throwable)this.createModuleException(RateLimiterError.UNEXPECTED_ATTRIBUTES_TYPE));
                            }
                        } else {
                            this.callback.error((Throwable)this.createModuleException(RateLimiterError.MISSING_ATTRIBUTES));
                        }
                    }
                }, (error, previous) -> this.callback.error(error));
            }
        }

        private void delayExecution(Map<String, String> headers) {
            ++this.retryIndex;
            if (this.retryIndex <= this.numberOfRetries) {
                long delay = this.computeDelay(headers);
                logger.info("computed delay: {} ms", (Object)delay);
                waitTimes.storeWaitTime(this.id, delay + System.currentTimeMillis());
                RatelimiterOperations.this.scheduledExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
            } else {
                this.callback.error((Throwable)this.createModuleException(RateLimiterError.RETRIES_EXHAUSTED));
            }
        }

        private long computeAdditionalJoinDelay() {
            BindingContext context = BindingContext.builder().build();
            TypedValue expressionResult = RatelimiterOperations.this.expressionManager.evaluate(this.joinWaitTimeExpression, context);
            return this.extractLongResult(expressionResult);
        }

        private long computeDelay(Map<String, String> headers) {
            BindingContext context = BindingContext.builder().addBinding("headers", TypedValue.of(headers)).addBinding("retryIndex", TypedValue.of((Object)this.retryIndex)).build();
            TypedValue expressionResult = RatelimiterOperations.this.expressionManager.evaluate(this.waitTimeExpression, context);
            return this.extractLongResult(expressionResult);
        }

        private long extractLongResult(TypedValue<?> expressionResult) {
            long delay;
            DataType dataType = expressionResult.getDataType();
            if (Number.class.isAssignableFrom(dataType.getType())) {
                delay = ((Number)expressionResult.getValue()).longValue();
            } else if (String.class.isAssignableFrom(dataType.getType())) {
                String delayStr = (String)expressionResult.getValue();
                try {
                    delay = Long.valueOf(delayStr);
                }
                catch (NumberFormatException e) {
                    throw this.createModuleException(RateLimiterError.INVALID_NUMBER);
                }
            } else {
                throw this.createModuleException(RateLimiterError.INVALID_NUMBER);
            }
            return delay;
        }

        private ModuleException createModuleException(RateLimiterError e) {
            return new ModuleException(I18nMessageFactory.createStaticMessage((String)e.toString()), (ErrorTypeDefinition)e);
        }
    }
}

