/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.mule.rusff.api;

import de.codecentric.mule.rusff.api.FailMode;
import de.codecentric.mule.rusff.api.RepeatErrorType;
import de.codecentric.mule.rusff.internal.NumberErrorType;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.sdk.api.annotation.param.MediaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOperations
implements Stoppable,
Startable {
    private static Logger logger = LoggerFactory.getLogger(RepeatOperations.class);
    @Inject
    private ExpressionManager expressionManager;
    @Inject
    private SchedulerService schedulerService;
    private ScheduledExecutorService scheduledExecutor;

    public void start() {
        SchedulerConfig config = SchedulerConfig.config().withMaxConcurrentTasks(10).withShutdownTimeout(1L, TimeUnit.SECONDS).withPrefix("repeat-until-successful-ff").withName("operations");
        this.scheduledExecutor = this.schedulerService.customScheduler(config);
    }

    public void stop() {
        this.scheduledExecutor.shutdown();
    }

    @Alias(value="repeat-until-successful-ff")
    @Throws(value={NumberErrorType.class})
    @MediaType(value="*/*")
    public void repeat(Chain operations, CompletionCallback<Object, Object> callback, @Summary(value="How often shall the operation be retried when the first try failed?") int numberOfRetries, @Summary(value="Time between initial call and first retry, in milliseconds") int initialDelay, @Summary(value="A DataWeave expression to compute the wait time, starting with the second retry. The following predefined variables exist: initialDelay: Delay between initial call and first retry, lastDelay: Last delay in millisedonds, retryIndex: Which try is this (counted from 0). When expression is empty, initialDelay will be used for all delays.") @org.mule.runtime.extension.api.annotation.param.Optional @Expression(value=ExpressionSupport.REQUIRED) Literal<String> followUpDelay, @Summary(value="Regular expression for errors (NAMESPACE:TYPE), in case of match, no retry will be done.") @org.mule.runtime.extension.api.annotation.param.Optional @Expression(value=ExpressionSupport.NOT_SUPPORTED) String failFastPattern, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="FAIL_ON_MATCH") FailMode mode) {
        RepeatRunner repeatRunner = new RepeatRunner(operations, callback, numberOfRetries, initialDelay, this.createFollowUpLiteral(followUpDelay), this.createOptionalPattern(failFastPattern), mode);
        repeatRunner.run();
    }

    private Optional<String> createFollowUpLiteral(Literal<String> followUpDelay) {
        if (followUpDelay == null) {
            return Optional.empty();
        }
        return followUpDelay.getLiteralValue();
    }

    private Optional<Pattern> createOptionalPattern(String failFastPattern) {
        if (StringUtils.isEmpty((CharSequence)failFastPattern)) {
            return Optional.empty();
        }
        return Optional.of(Pattern.compile(failFastPattern));
    }

    static String extractErrorType(Map<String, Object> info) {
        Object errorType = info.get("Error type");
        if (errorType instanceof String) {
            return (String)errorType;
        }
        ErrorType et = (ErrorType)errorType;
        return et.getNamespace() + ":" + et.getIdentifier();
    }

    private class RepeatRunner
    implements Runnable {
        private Chain operations;
        private CompletionCallback<Object, Object> callback;
        private int numberOfRetries;
        private int initialDelay;
        private Optional<String> followUpDelay;
        private Optional<Pattern> failFastPattern;
        private FailMode mode;
        private int lastDelay;
        private int retryIndex;

        private RepeatRunner(Chain operations, CompletionCallback<Object, Object> callback, int numberOfRetries, int initialDelay, Optional<String> followUpDelay, Optional<Pattern> failFastPattern, FailMode mode) {
            this.operations = operations;
            this.callback = callback;
            this.numberOfRetries = numberOfRetries;
            this.initialDelay = initialDelay;
            this.lastDelay = initialDelay;
            this.followUpDelay = followUpDelay;
            this.failFastPattern = failFastPattern;
            this.mode = mode;
        }

        @Override
        public void run() {
            this.operations.process(result -> {
                logger.debug("success, payload = {}", result.getOutput());
                this.callback.success(result);
            }, (error, previous) -> {
                if (error instanceof MuleException) {
                    MuleException exception = (MuleException)error;
                    Map info = exception.getInfo();
                    String namespaceAndIdentifier = RepeatOperations.extractErrorType(info);
                    logger.info("try {} of {} failed with error {}", new Object[]{this.retryIndex + 1, this.numberOfRetries + 1, namespaceAndIdentifier});
                    if (this.failFastPattern.isPresent() && this.failFastPattern.get().matcher(namespaceAndIdentifier).matches() == (this.mode == FailMode.FAIL_ON_MATCH) || this.retryIndex >= this.numberOfRetries) {
                        logger.warn("tries exhausted, throwing error {}", (Object)namespaceAndIdentifier);
                        this.callback.error(error);
                    } else {
                        ++this.retryIndex;
                        if (this.retryIndex > 1 && this.followUpDelay.isPresent()) {
                            BindingContext context = BindingContext.builder().addBinding("initialDelay", TypedValue.of((Object)this.initialDelay)).addBinding("lastDelay", TypedValue.of((Object)this.lastDelay)).addBinding("retryIndex", TypedValue.of((Object)this.retryIndex)).build();
                            TypedValue expressionResult = RepeatOperations.this.expressionManager.evaluateLogExpression(this.followUpDelay.get(), context);
                            DataType dataType = expressionResult.getDataType();
                            if (Number.class.isAssignableFrom(dataType.getType())) {
                                this.lastDelay = ((Number)expressionResult.getValue()).intValue();
                            } else if (String.class.isAssignableFrom(dataType.getType())) {
                                String lastDelayStr = (String)expressionResult.getValue();
                                try {
                                    this.lastDelay = Integer.valueOf(lastDelayStr);
                                }
                                catch (NumberFormatException e) {
                                    throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Delay must be number"), (ErrorTypeDefinition)RepeatErrorType.INVALID_NUMBER);
                                }
                            } else {
                                throw new ModuleException(I18nMessageFactory.createStaticMessage((String)"Delay must be number"), (ErrorTypeDefinition)RepeatErrorType.INVALID_NUMBER);
                            }
                            logger.debug("computed delay: {}", (Object)this.lastDelay);
                        }
                        RepeatOperations.this.scheduledExecutor.schedule(this, (long)this.lastDelay, TimeUnit.MILLISECONDS);
                    }
                } else {
                    this.callback.error(error);
                }
            });
        }
    }
}

