/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.boot.admin.server.ui.config.AdminServerUiProperties;
import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensions;
import de.codecentric.boot.admin.server.web.AdminController;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.aot.hint.annotation.RegisterReflectionForBinding;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@AdminController
public class UiController {
    private final String publicUrl;
    private final UiExtensions uiExtensions;
    private final Settings uiSettings;

    public UiController(String publicUrl, UiExtensions uiExtensions, Settings uiSettings) {
        this.publicUrl = publicUrl;
        this.uiExtensions = uiExtensions;
        this.uiSettings = uiSettings;
    }

    @ModelAttribute(value="baseUrl", binding=false)
    public String getBaseUrl(UriComponentsBuilder uriBuilder) {
        UriComponents publicComponents = UriComponentsBuilder.fromUriString((String)this.publicUrl).build();
        if (publicComponents.getScheme() != null) {
            uriBuilder.scheme(publicComponents.getScheme());
        }
        if (publicComponents.getHost() != null) {
            uriBuilder.host(publicComponents.getHost());
        }
        if (publicComponents.getPort() != -1) {
            uriBuilder.port(publicComponents.getPort());
        }
        if (publicComponents.getPath() != null) {
            uriBuilder.path(publicComponents.getPath());
        }
        return uriBuilder.path("/").toUriString();
    }

    @ModelAttribute(value="uiSettings", binding=false)
    public Settings getUiSettings() {
        return this.uiSettings;
    }

    @ModelAttribute(value="cssExtensions", binding=false)
    public List<UiExtension> getCssExtensions() {
        return this.uiExtensions.getCssExtensions();
    }

    @ModelAttribute(value="jsExtensions", binding=false)
    public List<UiExtension> getJsExtensions() {
        return this.uiExtensions.getJsExtensions();
    }

    @ModelAttribute(value="user", binding=false)
    public Map<String, Object> getUser(@Nullable Principal principal) {
        if (principal != null) {
            return Collections.singletonMap("name", principal.getName());
        }
        return Collections.emptyMap();
    }

    @GetMapping(path={"/"}, produces={"text/html"})
    @RegisterReflectionForBinding(value={String.class})
    public String index() {
        return "index";
    }

    @GetMapping(path={"/sba-settings.js"}, produces={"application/javascript"})
    public String sbaSettings() {
        return "sba-settings.js";
    }

    @GetMapping(path={"/variables.css"}, produces={"text/css"})
    public String variablesCss() {
        return "variables.css";
    }

    @GetMapping(path={"/login"}, produces={"text/html"})
    public String login() {
        return "login";
    }

    public static class Settings {
        private final String title;
        private final String brand;
        private final String loginIcon;
        private final String favicon;
        private final String faviconDanger;
        private final AdminServerUiProperties.PollTimer pollTimer;
        private final AdminServerUiProperties.UiTheme theme;
        private final boolean notificationFilterEnabled;
        private final boolean rememberMeEnabled;
        private final List<String> availableLanguages;
        private final List<String> routes;
        private final List<ExternalView> externalViews;
        private final List<ViewSettings> viewSettings;
        private final Boolean enableToasts;
        private final Boolean hideInstanceUrl;

        @Generated
        Settings(String title, String brand, String loginIcon, String favicon, String faviconDanger, AdminServerUiProperties.PollTimer pollTimer, AdminServerUiProperties.UiTheme theme, boolean notificationFilterEnabled, boolean rememberMeEnabled, List<String> availableLanguages, List<String> routes, List<ExternalView> externalViews, List<ViewSettings> viewSettings, Boolean enableToasts, Boolean hideInstanceUrl) {
            this.title = title;
            this.brand = brand;
            this.loginIcon = loginIcon;
            this.favicon = favicon;
            this.faviconDanger = faviconDanger;
            this.pollTimer = pollTimer;
            this.theme = theme;
            this.notificationFilterEnabled = notificationFilterEnabled;
            this.rememberMeEnabled = rememberMeEnabled;
            this.availableLanguages = availableLanguages;
            this.routes = routes;
            this.externalViews = externalViews;
            this.viewSettings = viewSettings;
            this.enableToasts = enableToasts;
            this.hideInstanceUrl = hideInstanceUrl;
        }

        @Generated
        public static SettingsBuilder builder() {
            return new SettingsBuilder();
        }

        @Generated
        public String getTitle() {
            return this.title;
        }

        @Generated
        public String getBrand() {
            return this.brand;
        }

        @Generated
        public String getLoginIcon() {
            return this.loginIcon;
        }

        @Generated
        public String getFavicon() {
            return this.favicon;
        }

        @Generated
        public String getFaviconDanger() {
            return this.faviconDanger;
        }

        @Generated
        public AdminServerUiProperties.PollTimer getPollTimer() {
            return this.pollTimer;
        }

        @Generated
        public AdminServerUiProperties.UiTheme getTheme() {
            return this.theme;
        }

        @Generated
        public boolean isNotificationFilterEnabled() {
            return this.notificationFilterEnabled;
        }

        @Generated
        public boolean isRememberMeEnabled() {
            return this.rememberMeEnabled;
        }

        @Generated
        public List<String> getAvailableLanguages() {
            return this.availableLanguages;
        }

        @Generated
        public List<String> getRoutes() {
            return this.routes;
        }

        @Generated
        public List<ExternalView> getExternalViews() {
            return this.externalViews;
        }

        @Generated
        public List<ViewSettings> getViewSettings() {
            return this.viewSettings;
        }

        @Generated
        public Boolean getEnableToasts() {
            return this.enableToasts;
        }

        @Generated
        public Boolean getHideInstanceUrl() {
            return this.hideInstanceUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isNotificationFilterEnabled() != other.isNotificationFilterEnabled()) {
                return false;
            }
            if (this.isRememberMeEnabled() != other.isRememberMeEnabled()) {
                return false;
            }
            Boolean this$enableToasts = this.getEnableToasts();
            Boolean other$enableToasts = other.getEnableToasts();
            if (this$enableToasts == null ? other$enableToasts != null : !((Object)this$enableToasts).equals(other$enableToasts)) {
                return false;
            }
            Boolean this$hideInstanceUrl = this.getHideInstanceUrl();
            Boolean other$hideInstanceUrl = other.getHideInstanceUrl();
            if (this$hideInstanceUrl == null ? other$hideInstanceUrl != null : !((Object)this$hideInstanceUrl).equals(other$hideInstanceUrl)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$loginIcon = this.getLoginIcon();
            String other$loginIcon = other.getLoginIcon();
            if (this$loginIcon == null ? other$loginIcon != null : !this$loginIcon.equals(other$loginIcon)) {
                return false;
            }
            String this$favicon = this.getFavicon();
            String other$favicon = other.getFavicon();
            if (this$favicon == null ? other$favicon != null : !this$favicon.equals(other$favicon)) {
                return false;
            }
            String this$faviconDanger = this.getFaviconDanger();
            String other$faviconDanger = other.getFaviconDanger();
            if (this$faviconDanger == null ? other$faviconDanger != null : !this$faviconDanger.equals(other$faviconDanger)) {
                return false;
            }
            AdminServerUiProperties.PollTimer this$pollTimer = this.getPollTimer();
            AdminServerUiProperties.PollTimer other$pollTimer = other.getPollTimer();
            if (this$pollTimer == null ? other$pollTimer != null : !((Object)this$pollTimer).equals(other$pollTimer)) {
                return false;
            }
            AdminServerUiProperties.UiTheme this$theme = this.getTheme();
            AdminServerUiProperties.UiTheme other$theme = other.getTheme();
            if (this$theme == null ? other$theme != null : !((Object)this$theme).equals(other$theme)) {
                return false;
            }
            List<String> this$availableLanguages = this.getAvailableLanguages();
            List<String> other$availableLanguages = other.getAvailableLanguages();
            if (this$availableLanguages == null ? other$availableLanguages != null : !((Object)this$availableLanguages).equals(other$availableLanguages)) {
                return false;
            }
            List<String> this$routes = this.getRoutes();
            List<String> other$routes = other.getRoutes();
            if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
                return false;
            }
            List<ExternalView> this$externalViews = this.getExternalViews();
            List<ExternalView> other$externalViews = other.getExternalViews();
            if (this$externalViews == null ? other$externalViews != null : !((Object)this$externalViews).equals(other$externalViews)) {
                return false;
            }
            List<ViewSettings> this$viewSettings = this.getViewSettings();
            List<ViewSettings> other$viewSettings = other.getViewSettings();
            return !(this$viewSettings == null ? other$viewSettings != null : !((Object)this$viewSettings).equals(other$viewSettings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isNotificationFilterEnabled() ? 79 : 97);
            result = result * 59 + (this.isRememberMeEnabled() ? 79 : 97);
            Boolean $enableToasts = this.getEnableToasts();
            result = result * 59 + ($enableToasts == null ? 43 : ((Object)$enableToasts).hashCode());
            Boolean $hideInstanceUrl = this.getHideInstanceUrl();
            result = result * 59 + ($hideInstanceUrl == null ? 43 : ((Object)$hideInstanceUrl).hashCode());
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $loginIcon = this.getLoginIcon();
            result = result * 59 + ($loginIcon == null ? 43 : $loginIcon.hashCode());
            String $favicon = this.getFavicon();
            result = result * 59 + ($favicon == null ? 43 : $favicon.hashCode());
            String $faviconDanger = this.getFaviconDanger();
            result = result * 59 + ($faviconDanger == null ? 43 : $faviconDanger.hashCode());
            AdminServerUiProperties.PollTimer $pollTimer = this.getPollTimer();
            result = result * 59 + ($pollTimer == null ? 43 : ((Object)$pollTimer).hashCode());
            AdminServerUiProperties.UiTheme $theme = this.getTheme();
            result = result * 59 + ($theme == null ? 43 : ((Object)$theme).hashCode());
            List<String> $availableLanguages = this.getAvailableLanguages();
            result = result * 59 + ($availableLanguages == null ? 43 : ((Object)$availableLanguages).hashCode());
            List<String> $routes = this.getRoutes();
            result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
            List<ExternalView> $externalViews = this.getExternalViews();
            result = result * 59 + ($externalViews == null ? 43 : ((Object)$externalViews).hashCode());
            List<ViewSettings> $viewSettings = this.getViewSettings();
            result = result * 59 + ($viewSettings == null ? 43 : ((Object)$viewSettings).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UiController.Settings(title=" + this.getTitle() + ", brand=" + this.getBrand() + ", loginIcon=" + this.getLoginIcon() + ", favicon=" + this.getFavicon() + ", faviconDanger=" + this.getFaviconDanger() + ", pollTimer=" + this.getPollTimer() + ", theme=" + this.getTheme() + ", notificationFilterEnabled=" + this.isNotificationFilterEnabled() + ", rememberMeEnabled=" + this.isRememberMeEnabled() + ", availableLanguages=" + this.getAvailableLanguages() + ", routes=" + this.getRoutes() + ", externalViews=" + this.getExternalViews() + ", viewSettings=" + this.getViewSettings() + ", enableToasts=" + this.getEnableToasts() + ", hideInstanceUrl=" + this.getHideInstanceUrl() + ")";
        }

        @Generated
        public static class SettingsBuilder {
            @Generated
            private String title;
            @Generated
            private String brand;
            @Generated
            private String loginIcon;
            @Generated
            private String favicon;
            @Generated
            private String faviconDanger;
            @Generated
            private AdminServerUiProperties.PollTimer pollTimer;
            @Generated
            private AdminServerUiProperties.UiTheme theme;
            @Generated
            private boolean notificationFilterEnabled;
            @Generated
            private boolean rememberMeEnabled;
            @Generated
            private List<String> availableLanguages;
            @Generated
            private List<String> routes;
            @Generated
            private List<ExternalView> externalViews;
            @Generated
            private List<ViewSettings> viewSettings;
            @Generated
            private Boolean enableToasts;
            @Generated
            private Boolean hideInstanceUrl;

            @Generated
            SettingsBuilder() {
            }

            @Generated
            public SettingsBuilder title(String title) {
                this.title = title;
                return this;
            }

            @Generated
            public SettingsBuilder brand(String brand) {
                this.brand = brand;
                return this;
            }

            @Generated
            public SettingsBuilder loginIcon(String loginIcon) {
                this.loginIcon = loginIcon;
                return this;
            }

            @Generated
            public SettingsBuilder favicon(String favicon) {
                this.favicon = favicon;
                return this;
            }

            @Generated
            public SettingsBuilder faviconDanger(String faviconDanger) {
                this.faviconDanger = faviconDanger;
                return this;
            }

            @Generated
            public SettingsBuilder pollTimer(AdminServerUiProperties.PollTimer pollTimer) {
                this.pollTimer = pollTimer;
                return this;
            }

            @Generated
            public SettingsBuilder theme(AdminServerUiProperties.UiTheme theme) {
                this.theme = theme;
                return this;
            }

            @Generated
            public SettingsBuilder notificationFilterEnabled(boolean notificationFilterEnabled) {
                this.notificationFilterEnabled = notificationFilterEnabled;
                return this;
            }

            @Generated
            public SettingsBuilder rememberMeEnabled(boolean rememberMeEnabled) {
                this.rememberMeEnabled = rememberMeEnabled;
                return this;
            }

            @Generated
            public SettingsBuilder availableLanguages(List<String> availableLanguages) {
                this.availableLanguages = availableLanguages;
                return this;
            }

            @Generated
            public SettingsBuilder routes(List<String> routes) {
                this.routes = routes;
                return this;
            }

            @Generated
            public SettingsBuilder externalViews(List<ExternalView> externalViews) {
                this.externalViews = externalViews;
                return this;
            }

            @Generated
            public SettingsBuilder viewSettings(List<ViewSettings> viewSettings) {
                this.viewSettings = viewSettings;
                return this;
            }

            @Generated
            public SettingsBuilder enableToasts(Boolean enableToasts) {
                this.enableToasts = enableToasts;
                return this;
            }

            @Generated
            public SettingsBuilder hideInstanceUrl(Boolean hideInstanceUrl) {
                this.hideInstanceUrl = hideInstanceUrl;
                return this;
            }

            @Generated
            public Settings build() {
                return new Settings(this.title, this.brand, this.loginIcon, this.favicon, this.faviconDanger, this.pollTimer, this.theme, this.notificationFilterEnabled, this.rememberMeEnabled, this.availableLanguages, this.routes, this.externalViews, this.viewSettings, this.enableToasts, this.hideInstanceUrl);
            }

            @Generated
            public String toString() {
                return "UiController.Settings.SettingsBuilder(title=" + this.title + ", brand=" + this.brand + ", loginIcon=" + this.loginIcon + ", favicon=" + this.favicon + ", faviconDanger=" + this.faviconDanger + ", pollTimer=" + this.pollTimer + ", theme=" + this.theme + ", notificationFilterEnabled=" + this.notificationFilterEnabled + ", rememberMeEnabled=" + this.rememberMeEnabled + ", availableLanguages=" + this.availableLanguages + ", routes=" + this.routes + ", externalViews=" + this.externalViews + ", viewSettings=" + this.viewSettings + ", enableToasts=" + this.enableToasts + ", hideInstanceUrl=" + this.hideInstanceUrl + ")";
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class ViewSettings {
        private final String name;
        private boolean enabled;

        public ViewSettings(String name, boolean enabled) {
            Assert.hasText((String)name, (String)"'name' must not be empty");
            this.name = name;
            this.enabled = enabled;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ViewSettings)) {
                return false;
            }
            ViewSettings other = (ViewSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ViewSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UiController.ViewSettings(name=" + this.getName() + ", enabled=" + this.isEnabled() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class ExternalView {
        private final String label;
        private final String url;
        private final Integer order;
        private final boolean iframe;
        private final List<ExternalView> children;

        public ExternalView(String label, String url, Integer order, boolean iframe, List<ExternalView> children) {
            Assert.hasText((String)label, (String)"'label' must not be empty");
            if (CollectionUtils.isEmpty(children)) {
                Assert.hasText((String)url, (String)"'url' must not be empty");
            }
            this.label = label;
            this.url = url;
            this.order = order;
            this.iframe = iframe;
            this.children = children;
        }

        @Generated
        public String getLabel() {
            return this.label;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public Integer getOrder() {
            return this.order;
        }

        @Generated
        public boolean isIframe() {
            return this.iframe;
        }

        @Generated
        public List<ExternalView> getChildren() {
            return this.children;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalView)) {
                return false;
            }
            ExternalView other = (ExternalView)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isIframe() != other.isIframe()) {
                return false;
            }
            Integer this$order = this.getOrder();
            Integer other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            List<ExternalView> this$children = this.getChildren();
            List<ExternalView> other$children = other.getChildren();
            return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ExternalView;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isIframe() ? 79 : 97);
            Integer $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            List<ExternalView> $children = this.getChildren();
            result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UiController.ExternalView(label=" + this.getLabel() + ", url=" + this.getUrl() + ", order=" + this.getOrder() + ", iframe=" + this.isIframe() + ", children=" + this.getChildren() + ")";
        }
    }
}

